/*
 * Decompiled with CFR 0.152.
 */
package de.mud.telnet;

import de.mud.jta.Wrapper;
import de.mud.telnet.TelnetProtocolHandler;
import java.awt.Dimension;
import java.io.IOException;

public class TelnetWrapper
extends Wrapper {
    protected TelnetProtocolHandler handler = new TelnetProtocolHandler(){

        public String getTerminalType() {
            return "vt320";
        }

        public Dimension getWindowSize() {
            return new Dimension(80, 25);
        }

        public void setLocalEcho(boolean echo) {
        }

        public void write(byte[] b) throws IOException {
            TelnetWrapper.this.out.write(b);
        }

        public void notifyEndOfRecord() {
        }
    };
    private static final int debug = 0;

    public TelnetProtocolHandler getHandler() {
        return this.handler;
    }

    public void connect(String host, int port) throws IOException {
        super.connect(host, port);
        this.handler.reset();
    }

    public String send(String cmd) throws IOException {
        byte[] arr = (cmd + "\n").getBytes();
        this.handler.transpose(arr);
        if (this.getPrompt() != null) {
            return this.waitfor(this.getPrompt());
        }
        return null;
    }

    public int read(byte[] b) throws IOException {
        int n = this.handler.negotiate(b);
        if (n > 0) {
            return n;
        }
        while (n <= 0) {
            do {
                if ((n = this.handler.negotiate(b)) <= 0) continue;
                return n;
            } while (n == 0);
            n = this.in.read(b);
            if (n < 0) {
                return n;
            }
            this.handler.inputfeed(b, n);
            n = this.handler.negotiate(b);
        }
        return n;
    }
}

