/*
 * Decompiled with CFR 0.152.
 */
package de.mud.flash;

import de.mud.flash.FlashTerminal;
import de.mud.telnet.TelnetProtocolHandler;
import de.mud.terminal.vt320;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class FlashTerminalServer
implements Runnable {
    private static final int debug = 0;
    private Socket socket;
    private InputStream is;
    private OutputStream os;
    private boolean running;
    private vt320 emulation = new vt320(){

        public void write(byte[] b) {
            try {
                if (FlashTerminalServer.this.localecho) {
                    FlashTerminalServer.this.emulation.putString(new String(b) + "\r");
                }
                FlashTerminalServer.this.telnet.transpose(b);
            }
            catch (IOException e) {
                System.err.println("FlashTerminalServer: error sending data: " + e);
            }
        }
    };
    private FlashTerminal terminal;
    private TelnetProtocolHandler telnet = new TelnetProtocolHandler(){

        public String getTerminalType() {
            return FlashTerminalServer.this.emulation.getTerminalID();
        }

        public Dimension getWindowSize() {
            return new Dimension(FlashTerminalServer.this.emulation.getColumns(), FlashTerminalServer.this.emulation.getRows());
        }

        public void setLocalEcho(boolean echo) {
            FlashTerminalServer.this.localecho = true;
        }

        public void notifyEndOfRecord() {
            FlashTerminalServer.this.terminal.redraw();
        }

        public void write(byte[] b) throws IOException {
            FlashTerminalServer.this.os.write(b);
        }
    };
    private boolean localecho = true;

    public static void main(String[] args) {
        System.out.println("FlashTerminalServer (c) 2002 Matthias L. Jugel, Marcus Mei\u00dfner");
        if (args.length < 2) {
            System.err.println("usage: FlashTerminalServer host port");
            System.exit(0);
        }
        try {
            ServerSocket serverSocket = new ServerSocket(8080);
            while (true) {
                System.out.println("FlashTerminalServer: waiting for connection ...");
                Socket flashClientSocket = serverSocket.accept();
                System.out.println("FlashTerminalServer: Connect to: " + flashClientSocket);
                new FlashTerminalServer(args[0], args[1], flashClientSocket);
            }
        }
        catch (IOException e) {
            System.err.println("FlashTerminalServer: error opening server socket: " + e);
            return;
        }
    }

    public FlashTerminalServer(String host, String port, Socket flashSocket) {
        try {
            this.terminal = new FlashTerminal(){

                public void disconnect() {
                    FlashTerminalServer.this.running = false;
                    try {
                        FlashTerminalServer.this.socket.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            this.terminal.setVDUBuffer(this.emulation);
            this.socket = new Socket(host, Integer.parseInt(port));
            this.is = this.socket.getInputStream();
            this.os = this.socket.getOutputStream();
            new Thread(this).start();
            this.terminal.start(flashSocket);
        }
        catch (IOException e) {
            System.err.println("FlashTerminalServer: error connecting to remote host: " + e);
        }
        catch (NumberFormatException e) {
            System.err.println("FlashTerminalServer: " + port + " is not a correct number");
        }
    }

    public void run() {
        this.running = true;
        byte[] b = new byte[4096];
        int n = 0;
        if (this.running && n >= 0) {
            try {
                n = this.telnet.negotiate(b);
                if (n > 0) {
                    this.emulation.putString(new String(b, 0, n));
                }
                while (true) {
                    if ((n = this.is.read(b)) <= 0) {
                        continue;
                    }
                    this.telnet.inputfeed(b, n);
                    n = 0;
                    do {
                        if ((n = this.telnet.negotiate(b)) <= 0) continue;
                        this.emulation.putString(new String(b, 0, n));
                    } while (n != -1);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.err.println("FlashTerminalServer: finished reading from remote host");
    }
}

