Unit MCFG_FBASES;

{$I M_OPS.PAS}

Interface

Procedure FileBaseEditor;

Implementation

Uses
  m_MenuBox,
  m_MenuForm,
  m_Strings,
  m_FileIO,
  MCFG_Common;

Var
  FBaseFile : TBufFile;
  FBase     : RecFileBase;

Procedure EditFileBase;
Var
  Box   : TMenuBox;
  Form  : TMenuForm;
  Topic : String;
  Count : Byte;
Begin
  Topic := '|03(|09File Base Edit|03) |01-|09> |15';
  Box   := TMenuBox.Create(Console);
  Form  := TMenuForm.Create(Console);

  Box.Open (7, 5, 74, 21);

  VerticalLine (22,  6, 14);
  VerticalLine (26, 16, 20);
  VerticalLine (68, 12, 13);

  Form.AddStr  ('N', ' Name '        , 16,  6, 24,  6,  6, 40, 40, @FBase.Name, Topic + 'File base description');
  Form.AddStr  ('F', ' File Name '   , 11,  7, 24,  7, 11, 40, 60, @FBase.FileName, Topic + 'File base storage file name');
  Form.AddStr  ('L', ' List ACS '    , 12,  8, 24,  8, 10, 30, 30, @FBase.ListACS, Topic + 'Access required to see in base list');
  Form.AddStr  ('U', ' Upload ACS '  , 10,  9, 24,  9, 12, 30, 30, @FBase.UploadACS, Topic + 'Access required to upload files');
  Form.AddStr  ('D', ' Download ACS ',  8, 10, 24, 10, 14, 30, 30, @FBase.DownloadACS, Topic + 'Access required to download files');
  Form.AddStr  ('S', ' Sysop ACS '   , 11, 11, 24, 11, 11, 30, 30, @FBase.SysopACS, Topic + 'Access required for Sysop access');
  Form.AddStr  ('I', ' Display File ',  8, 12, 24, 12, 14, 30, 30, @FBase.DispFile, Topic + 'Display file shown before listing');
  Form.AddBits ('T', ' No FTP '      , 14, 13, 24, 13,  8, RecFileBaseNoFTP, @FBase.Flags, Topic + 'Exclude from FTP server');
  Form.AddBits ('A', ' Anonymous '   , 11, 14, 24, 14, 11, RecFileBaseAnon, @FBase.Flags, Topic + 'Save all uploads as Anonymous uploader');
  Form.AddBol  ('E', ' Def New Scan ', 54, 12, 70, 12, 14,  3, @FBase.NewScan, Topic + 'Base is in user''s newscan by default?');
  Form.AddBits ('R', ' Free Files '  , 56, 13, 70, 13, 12, RecFileBaseFree, @FBase.Flags, Topic + 'All files in base are free?');

  Form.AddStr ('M', ' Main UL/DL Path ',  9, 16, 27, 16, 17, 39, 60, @FBase.Path[1].Path, Topic + 'Main Upload/Download directory');
  Form.AddBol ('@', 'CD'                , 67, 16, 70, 16,  2, 3, @FBase.Path[1].CDROM, Topic + 'Is slow media device?');

  For Count := 2 to 5 Do Begin
    Form.AddStr ('!', ' Alternative #' + strI2S(Count) + ' ', 10, 15 + Count, 27, 15 + Count, 16, 39, 60, @FBase.Path[Count].Path, Topic + 'Alternative file path #' + strI2S(Count));
    Form.AddBol ('@', 'CD'                                  , 67, 15 + Count, 70, 15 + Count,  2, 3, @FBase.Path[Count].CDROM, Topic + 'Is slow media device?');
  End;

  Repeat
    Case Form.Execute of
      #27 : Break;
    End;
  Until False;

  Box.Close;

  Form.Free;
  Box.Free;
End;

Procedure FileBaseEditor;
Var
  Box  : TMenuBox;
  List : TMenuList;

  Procedure MakeList;
  Var
    Tag : Byte;
  Begin
    List.Clear;

    FBaseFile.Reset;
    While Not FBaseFile.EOF Do Begin
      If FBaseFile.FilePos = 0 Then Tag := 2 Else Tag := 0;
      FBaseFile.Read (FBase);
      List.Add(strPadR(strI2S(FBaseFile.FilePos), 5, ' ') + '  ' + strStripMCI(FBase.Name), Tag);
    End;

    List.Add('', 2);
  End;

  Procedure InsertRecord;
  Begin
    FBaseFile.RecordInsert (List.Picked);

    FillChar (FBase, SizeOf(RecFileBase), 0);

    With FBase Do Begin
      FileName     := 'newfilebase';
      Path[1].Path := bbsConfig.PathSystem + 'xfers\newfiles\';
      Name         := 'New File Base';
      NewScan      := True;
      ListACS      := '';
      DownloadACS  := '';
      UploadACS    := '';
      DispFile     := '';
      SysopACS     := 's255';
      Flags        := 0;
    End;

    FBaseFile.Write(FBase);
  End;

Begin
  FBaseFile := TBufFile.Create(4096);

  If Not FBaseFile.Open(bbsConfig.PathData + 'fbases.dat', fmOpenCreate, fmReadWrite + fmDenyNone, SizeOf(RecFileBase)) Then Begin
    FBaseFile.Free;
    Exit;
  End;

  Box  := TMenuBox.Create(Console);
  List := TMenuList.Create(Console);

  //        StatusBot('CTRL+ (I) Insert (D) Delete (O) Sort (SPACE) Tag (G) Global (ENTER) Edit');

  List.NoWindow := True;
  List.LoChars  := #01#04#07#13#15#27;
  List.AllowTag := True;

  If FBaseFile.FileSize = 0 Then InsertRecord;

  Box.Open (15, 5, 65, 21);

  Console.WriteXY (17,  6, 112, '#####  File Base Description');
  Console.WriteXY (16,  7, 112, strRep('-', 49));
  Console.WriteXY (16, 19, 112, strRep('-', 49));
  Console.WriteXY (18, 20, 112, '(CTRL/A) Add   (CTRL/D) Delete   (ENTER) Edit');

  Repeat
    MakeList;

    List.Open (15, 7, 65, 19);
    List.Close;

    Case List.ExitCode of
      #01 : If List.Picked > 1 Then Begin
              InsertRecord;
              MakeList;
            End;
      #04 : If (List.Picked > 1) and (List.Picked < List.ListMax) Then
              If ShowMsgBox(1, 'Delete this entry?') Then Begin
                FBaseFile.Seek (List.Picked - 1);
                FBaseFile.Read (FBase);

                FBaseFile.RecordDelete (List.Picked);

                If ShowMsgBox(1, 'Delete file base data files?') Then Begin
                  FileErase (bbsConfig.PathData + FBase.FileName + '.dir');
                  FileErase (bbsConfig.PathData + FBase.FileName + '.dat');
                  FileErase (bbsConfig.PathData + FBase.FileName + '.scn');
                End;

                MakeList;
              End;
//      #07 : GlobalEdit;
      #13 : If List.Picked < List.ListMax Then Begin
              FBaseFile.Seek (List.Picked - 1);
              FBaseFile.Read (FBase);
              EditFileBase;
              FBaseFile.Seek  (List.Picked - 1);
              FBaseFile.Write (FBase);
            End;
//      #15 : SortFileBases;
      #27 : Break;
    End;
  Until False;

  Box.Close;

  FBaseFile.Free;
  List.Free;
  Box.Free;
End;

End.
