{$I M_OPS.PAS}

Unit m_Socket_Types;

// Socket record types common to all socket implementations on all
// platforms.  Since Winsock is based off of BSD Sockets, all socket
// records should be the same.

Interface

Const
  PF_INET     = 2;
  SOCK_STREAM = 1;
  INADDR_ANY  = 0;

Type
  u_short   = System.Word;
  u_long    = System.LongInt;
  short     = System.Integer;
  ulong     = u_long;
  TSocket   = System.LongInt;
  THostAddr = Array[1..4] of Byte;

  TSockAddr = Record
    sa_family : u_short;
    sa_data   : Array[1..14] of Char;
  End;

  SunB = Record
    s_b1, s_b2, s_b3, s_b4: Char;
  End;

  SunW = Record
    s_w1, s_w2: u_short;
  End;

  PInAddr = ^TInAddr;
  TInAddr = Record
    Case Integer of
      0: (S_un_b: SunB);
      1: (S_un_w: SunW);
      2: (S_addr: u_long);
  End;

(*
  TSockAddrIn = Record
    sin_family : u_short;
    sin_port   : u_short;
    sin_addr   : TInAddr;
    sin_zero   : Array[1..8] of Char;
  End;
*)
  TSockAddrIn = Record
    Case integer of
      0: (Sin_Family: u_short;
          Sin_Port:   u_short;
          Sin_Addr:   TInAddr;
          Sin_Zero:   array[1.. 8] of byte);
      1: (Sa_Family:  u_short;
          Sa_Addr:    array[1..14] of byte);
    end;

  PServEnt = ^TServEnt;
  TServEnt = Record
    s_name    : pchar;
    s_aliases : ^pchar;
    s_port    : Word;
    s_proto   : pchar;
  End;

  {$IFDEF LINUX}
    PHostEnt = ^THostEnt;
    THostEnt = Record
      Name     : pchar;
      Aliases  : ppchar;
      AddrType : LongInt;
      AddrLen  : LongInt;
//      AddrList : ppchar;
addrlist : ^pinAddr;
    End;
  {$ENDIF}
  {$IFDEF WIN32}
    PHostEnt = ^THostEnt;
    THostEnt = Record
      name     :  PChar;
      aliases  : ^PChar;
      addrtype : System.Word;
      length   : System.Word;
//      addrlist : ^pchar;
AddrList: ^pInAddr;

    End;
  {$ENDIF}

  PProtoEnt = ^TProtoEnt;
  TProtoEnt = Record
    p_name    : pchar;
    p_aliases : ^pchar;
    p_proto   : Integer;
  End;

Const
  NoAddress : THostAddr = (0,0,0,0);

Implementation

End.
