{$I M_OPS.PAS}

Unit BBS_Events;

Interface

Type
  BBSEventType = (
    evt_Error,
    evt_Inactive,
    evt_ConnectionLost
  );

  BBSEventProcType = Procedure (Sender: Pointer; Msg: String);

  TBBSEvent = Class
  Private
    Proc_Error          : BBSEventProcType;
    Proc_Inactive       : BBSEventProcType;
    Proc_ConnectionLost : BBSEventProcType;
  Public
    Constructor Create;
    Destructor  Destroy; Override;
    Procedure   SetHandlerProc (Event: BBSEventType; Proc: BBSEventProcType);
    Procedure   Trigger (Event: BBSEventType; Sender: Pointer; Msg: String);
  End;

Implementation

Constructor TBBSEvent.Create;
Begin
  Inherited Create;

  Proc_Error          := NIL;
  Proc_Inactive       := NIL;
  Proc_ConnectionLost := NIL;
End;

Destructor TBBSEvent.Destroy;
Begin
  Inherited Destroy;
End;

Procedure TBBSEvent.SetHandlerProc (Event: BBSEventType; Proc: BBSEventProcType);
Begin
  Case Event of
    evt_Error          : Proc_Error          := Proc;
    evt_Inactive       : Proc_Inactive       := Proc;
    evt_ConnectionLost : Proc_ConnectionLost := Proc;
  End;
End;

Procedure TBBSEvent.Trigger (Event: BBSEventType; Sender: Pointer; Msg: String);
Begin
  Case Event of
    evt_Error          : If Assigned(Proc_Error)          Then Proc_Error(Sender, Msg);
    evt_Inactive       : If Assigned(Proc_Inactive)       Then Proc_Inactive(Sender, Msg);
    evt_ConnectionLost : If Assigned(Proc_ConnectionLost) Then Proc_ConnectionLost(Sender, Msg);
  End;
End;

End.
