{$I M_OPS.PAS}

Unit BBS_Editor_Full;

Interface

Uses
  BBS_Common,
  BBS_Core,
  BBS_IO;

Function AnsiEditor (Var Term    : TBBSIO;
                     Var MsgText : RecMessageText;
                     Var Lines   : Integer;
                     WrapPos     : Byte;
                     MaxLines    : Integer;
                     TEdit,
                     Forced      : Boolean;
                     Var Subj    : String) : Boolean;

Implementation

Uses
  m_Strings;

Function AnsiEditor (Var Term: TBBSIO; Var MsgText: RecMessageText; Var Lines: Integer; WrapPos: Byte; MaxLines: Integer; TEdit, Forced: Boolean; Var Subj: String) : Boolean;
Const
  WinStart   : Byte    = 2;
  WinEnd     : Byte    = 22;
  TextColor  : Byte    = 7;
  InsertMode : Boolean = True;
Var
  Done         : Boolean;
  Save         : Boolean;
  Ch           : Char;
  CurX         : Byte;
  CurY         : Integer;
  CurLine      : Integer;
  TotalLine    : Integer;
  QuoteCurLine : Integer;
  QuoteTopPage : Integer;

Procedure UpdateCursor;
Begin
  If CurLine > TotalLine Then TotalLine := CurLine;
  If CurX > Length(MsgText[CurLine]) Then CurX := Length(MsgText[CurLine]) + 1;
  Term.OutRaw(Term.AnsiGotoXY(CurX, CurY));
End;

Procedure ScreenRefreshPart;
Var
  Count1 : Integer;
  Count2 : Integer;
Begin
  Term.BufAddStr(Term.AnsiGotoXY(1, CurY));

  Count1 := CurY;
  Count2 := CurLine;

  Repeat
    If Count2 <= TotalLine     Then Term.BufAddStr(MsgText[Count2]);
    If Count2 <= TotalLine + 1 Then Term.BufAddStr(Term.AnsiClrEOL + #13#10);

    Inc (Count1);
    Inc (Count2);
  Until Count1 > Term.ScreenInfo[2].Y;

  Term.BufFlush;

  UpdateCursor;
End;

Procedure ScreenRefreshFull;
Var
  Count1 : Integer;
  Count2 : Integer;
Begin
  CurY   := WinStart + 5;
  Count1 := CurLine  - 5;

  If Count1 < 1 Then Begin
    CurY   := WinStart + (5 + Count1 - 1);
    Count1 := 1;
  End;

  Term.BufAddStr (Term.AnsiGotoXY(1, WinStart));

  Count2 := WinStart;//Term.ScreenInfo[1].Y;

  Repeat
    If Count1 <= TotalLine Then Term.BufAddStr(MsgText[Count1]);
    Term.BufAddStr(Term.AnsiClrEOL + #13#10);
    Inc (Count2);
    Inc (Count1);
  Until Count2 > WinEnd; //Term.ScreenInfo[2].Y;

  Term.BufFlush;

  UpdateCursor;
End;

Procedure InsertLine (Num: Integer);
Var
  Count : Integer;
Begin
  Inc (TotalLine);

  For Count := TotalLine DownTo Num + 1 Do
    MsgText[Count] := MsgText[Count - 1];

  MsgText[Num] := '';
End;

Procedure DeleteLine (Num: Integer);
Var
  A : Integer;
Begin
  For A := Num To TotalLine - 1 Do
    MsgText[A] := MsgText[A + 1];

  MsgText[TotalLine] := '';
  Dec (TotalLine);
End;

Procedure TextReformat;
Var
  OldStr  : String; { holds the line text to be wrapped }
  NewStr  : String;
  Line    : Integer;   { holds current line number being wrapped }
  A       : Integer;
  NewY    : Integer;   { holds new y position on screen }
  NewLine : Integer;   { holds new line number }
  Moved   : Boolean;
Begin
  If TotalLine = MaxLines Then Exit;

  Line    := CurLine;
  OldStr  := MsgText[Line];
  NewY    := CurY;
  NewLine := CurLine;
  Moved   := False;

  Repeat
      If Pos(' ', OldStr) = 0 Then Begin
        Inc         (Line);
        InsertLine (Line);

        MsgText[Line]      := Copy(OldStr, CurX, Length(OldStr));
        MsgText[Line-1][0] := Chr(CurX - 1);

        If CurX > WrapPos Then Begin
          Inc (NewLine);
          Inc (NewY);
          CurX := 1;
        End;

        If NewY <= Term.ScreenInfo[2].Y Then ScreenRefreshPart;

        CurY    := NewY;
        CurLine := NewLine;

        If CurY > Term.ScreenInfo[2].Y Then ScreenRefreshFull Else UpdateCursor;

        Exit;
      End Else Begin
        A := strWrap (OldStr, NewStr, WrapPos);

        If (A > 0) And (Not Moved) And (CurX > Length(OldStr) + 1) Then Begin
          CurX  := CurX - A;
          Moved := True;
          Inc (NewLine);
          Inc (NewY);
        End;

        MsgText[Line] := OldStr;
        Inc (Line);

        If (MsgText[Line] = '') or ((Pos(' ', MsgText[Line]) = 0) And (Length(MsgText[Line]) >= WrapPos)) Then Begin
          InsertLine(Line);
          OldStr := NewStr;
        End Else
          OldStr := NewStr + ' ' + MsgText[Line];
      End;
  Until Length(OldStr) <= WrapPos;

  MsgText[Line] := OldStr;

  If NewY <= Term.ScreenInfo[2].Y Then Begin
    Term.BufAddStr(Term.AnsiGotoXY(1, CurY));

    A := CurLine;

    Repeat
      If (CurY + (A - CurLine) <= Term.ScreenInfo[2].Y) and (A <= TotalLine) Then Begin
        Term.BufAddStr (MsgText[A]);
        Term.BufAddStr (Term.AnsiClrEOL + #13#10);
      End Else
        Break;

      Inc (A);
    Until False;
  End;

  Term.BufFlush;

  CurY    := NewY;
  CurLine := NewLine;

  If CurY > Term.ScreenInfo[2].Y Then ScreenReFreshFull Else UpdateCursor;
End;

Procedure keyEnter;
Begin
  If TotalLine = MaxLines Then Exit;

  InsertLine (CurLine + 1);

  If CurX < Length(MsgText[CurLine]) + 1 Then Begin
    MsgText[CurLine+1] := Copy(MsgText[CurLine], CurX, Length(MsgText[CurLine]));
    Delete (MsgText[CurLine], CurX, Length(MsgText[CurLine]));
  End;

  If CurY + 1 > Term.ScreenInfo[2].Y Then ScreenRefreshFull Else ScreenRefreshPart;

  CurX := 1;

  Inc(CurY);
  Inc(CurLine);

  UpdateCursor;
End;

Procedure keyDownArrow;
Begin
  If CurLine = TotalLine Then Exit;

  If CurY = Term.ScreenInfo[2].Y Then
    ScreenRefreshFull
  Else Begin
    Inc (CurY);
    Inc (CurLine);

    UpdateCursor;
  End;
End;

Procedure keyUpArrow (EOL: Boolean);
Begin
  If CurLine > 1 Then Begin
    If EOL Then begin
      CurX := Length(MsgText[CurLine - 1]) + 1;
      If CurX > WrapPos Then CurX := WrapPos + 1;
    End;

    If CurY = WinStart {Term.ScreenInfo[1].Y} Then
      ScreenRefreshFull
    Else Begin
      Dec (CurY);
      Dec (CurLine);

      UpdateCursor;
    End;
  End;
End;

Procedure keyBackSpace;
Var
  A : Integer;
Begin
  If CurX > 1 Then Begin
    Term.OutBS(1, True);
    Dec (CurX);
    Delete (MsgText[CurLine], CurX, 1);
    If CurX < Length(MsgText[CurLine]) + 1 Then Begin
      Term.OutRaw(Copy(MsgText[CurLine], CurX, Length(MsgText[CurLine])) + ' ');
      // ^^ add to buffer??
      UpdateCursor;
    End;
  End Else
  If CurLine > 1 Then Begin
    If Length(MsgText[CurLine - 1]) + Length(MsgText[CurLine]) <= WrapPos Then Begin
      CurX := Length(MsgText[CurLine - 1]) + 1;
      MsgText[CurLine - 1] := MsgText[CurLine - 1] + MsgText[CurLine];
      DeleteLine (CurLine);
      Dec (CurLine);
      Dec (CurY);
      If CurY < WinStart Then ScreenRefreshFull Else ScreenRefreshPart;
    End Else
    If Pos(' ', MsgText[CurLine]) > 0 Then Begin
      For A := Length(MsgText[CurLine]) DownTo 1 Do
        If (MsgText[CurLine][A] = ' ') and (Length(MsgText[CurLine - 1]) + A - 1 <= WrapPos) Then Begin
          CurX := Length(MsgText[CurLine - 1]) + 1;
          MsgText[CurLine - 1] := MsgText[CurLine - 1] + Copy(MsgText[CurLine], 1, A - 1);
          Delete (MsgText[CurLine], 1, A);
          Dec (CurLine);
          Dec (CurY);
          If CurY < WinStart Then ScreenRefreshFull Else ScreenRefreshPart;
          Exit;
        End;
      keyUpArrow(True);
    End;
  End;
End;

Procedure keyLeftArrow;
Begin
  If CurX > 1 Then Begin
    Dec (CurX);
    UpdateCursor;
  End Else
    keyUpArrow(true);
End;

Procedure keyRightArrow;
Begin
  If CurX < Length(MsgText[CurLine]) + 1 Then Begin
    Inc (CurX);
    UpdateCursor;
  End Else
    keyDownArrow;
End;

Procedure keyToggleInsert (Toggle: Boolean);
Var
  Str : String;
Begin
  Str := TBBSCore(Term.Owner).GetPrompt(202);

  If Toggle Then InsertMode := Not InsertMode;

  Term.BufAddStr(Term.Attr2Ansi(Term.ScreenInfo[3].A, False) + Term.AnsiGotoXY(Term.ScreenInfo[3].X, Term.ScreenInfo[3].Y));

  If InsertMode Then Term.BufAddStr(strWordGet(1, Str, ' ')) Else Term.BufAddStr(strWordGet(2, Str, ' '));

  Term.BufAddStr(Term.AnsiGotoXY(CurX, CurY) + Term.Attr2Ansi(Term.ScreenInfo[1].A, False));
  Term.BufFlush;
End;

Procedure ScreenFullReDraw;
Begin
  If TEdit Then
    Term.ShowTemplate ('ansitext')
  Else
    Term.ShowTemplate ('ansiedit');

  WinStart  := Term.ScreenInfo[1].Y;
  WinEnd    := Term.ScreenInfo[2].Y;
  TextColor := Term.ScreenInfo[1].A;

  keyToggleInsert (False);

  ScreenRefreshFull;
End;

Procedure Quote;
Var
  InFile   : Text;
  Start    : Integer;
  Finish   : Integer;
  NumLines : Integer;
//  Temp     : String;
  Text     : Array[1..mysMaxMsgLines] of String[80];  // change to pointer
  PI1      : String;
  PI2      : String;
Begin
  Assign (InFile, TBBSCore(Term.Owner).TempPath + 'msgtmp');
  Reset  (InFile);

  If IoResult <> 0 Then Begin
    Term.OutFullLn (TBBSCore(Term.Owner).GetPrompt(107));
    Exit;
  End;

  NumLines        := 0;
  Term.AllowPause := True;

  While Not Eof(InFile) Do Begin
    Inc    (NumLines);
    ReadLn (InFile, Text[NumLines]);
  End;

  Close (InFile);

  PI1 := Term.PromptInfo['A'];
  PI2 := Term.PromptInfo['B'];

  Term.OutFullLn(TBBSCore(Term.Owner).GetPrompt(89));

  For Start := 1 to NumLines Do Begin
    Term.PromptInfo['A'] := strI2S(Start);
    Term.PromptInfo['B'] := Text[Start];

    Term.OutFullLn(TBBSCore(Term.Owner).GetPrompt(90));

    If (Term.PausePos >= TBBSCore(Term.Owner).User.ThisUser.ScreenSize) and (Term.AllowPause) Then
      Case Term.MorePrompt of
        'N' : Break;
        'C' : Term.AllowPause := False;
      End;
  End;

  Term.AllowPause := True;

  Term.OutFull(TBBSCore(Term.Owner).GetPrompt(91));
  Start := strS2I(Term.GetStr(3, 3, -1, ''));

  Term.OutFull(TBBSCore(Term.Owner).GetPrompt(92));
  Finish := strS2I(Term.GetStr(3, 3, -1, ''));

  If (Start > 0) and (Start <= NumLines) and (Finish <= NumLines) Then Begin
    If Finish = 0 Then Finish := Start;
    For NumLines := Start to Finish Do Begin
      If TotalLine = mysMaxMsgLines Then Break;
      If MsgText[CurLine] <> '' Then Begin
        Inc (CurLine);
        InsertLine (CurLine);
      End;
      MsgText[CurLine] := Text[NumLines];
    End;
    If CurLine < MaxLines Then Inc(CurLine);
  End;

  Term.PromptInfo['A'] := PI1;
  Term.PromptInfo['B'] := PI2;
End;

Procedure QuoteWindow;
Const
  ColorQuote = 31;
Var
  QText      : Array[1..mysMaxMsgLines] of String[79];
  InFile     : Text;
  QuoteLines : Integer;
  NoMore     : Boolean;

  Procedure UpdateBar (IsOn: Boolean);
  Begin
    Term.BufAddStr(Term.AnsiGotoXY(1, QuoteCurLine + Term.ScreenInfo[2].Y));

    If IsOn Then
      Term.BufAddStr(Term.Attr2Ansi(ColorQuote, False))
    Else
      Term.BufAddStr(Term.Attr2Ansi(Term.ScreenInfo[2].A, False));

    Term.BufAddStr(strPadR(QText[QuoteTopPage + QuoteCurLine], 79, ' '));
    Term.BufFlush;
  End;

  Procedure UpdateWindow;
  Var
    Count : Integer;
//    Str   : String;
  Begin
    Term.BufAddStr(Term.AnsiGotoXY(1, Term.ScreenInfo[2].Y) + Term.Attr2Ansi(Term.ScreenInfo[2].A, False));

    For Count := QuoteTopPage to QuoteTopPage + 5 Do Begin
      If Count <= QuoteLines Then Term.BufAddStr(QText[Count]);
      Term.BufAddStr(Term.AnsiClrEOL);
      If Count <= QuoteLines Then Term.BufAddStr(#13#10);
    End;
    Term.BufFlush;
    UpdateBar(True);
  End;

Var
  Scroll : Integer;
  Temp1  : Integer;
  Ch     : Char;
  Added  : Boolean;
Begin
  Added := False;

  Assign (InFile, TBBSCore(Term.Owner).TempPath + 'msgtmp');
  Reset  (InFile);

  If IoResult <> 0 Then Begin
    Term.OutFullLn(TBBSCore(Term.Owner).GetPrompt(107));
    Exit;
  End;

  QuoteLines := 0;
  NoMore     := False;
  Scroll     := CurLine + 4;

  While Not Eof(InFile) Do Begin
    Inc    (QuoteLines);
    ReadLn (InFile, QText[QuoteLines]);
  End;

  Close (InFile);

  Term.ShowTemplate ('ansiquote');

  If TBBSCore(Term.Owner).ShutDown Then Exit;

  If CurY >= Term.ScreenInfo[1].Y Then Begin
    Term.OutRaw(Term.Attr2Ansi(TextColor, False));
    Temp1  := WinEnd;
    WinEnd := Term.ScreenInfo[1].Y;
    ScreenRefreshFull;
    WinEnd := Temp1;
  End;

  UpdateWindow;

  Repeat
    Ch := Term.NewGetKey(0);
    If Term.IsArrow Then Begin
      Case Ch of
        #72 : Begin
                If QuoteCurLine > 0 Then Begin
                  UpdateBar(False);
                  Dec(QuoteCurLine);
                  UpdateBar(True);
                End Else
                If QuoteTopPage > 1 Then Begin
                  Dec (QuoteTopPage);
                  UpdateWindow;
                End;
                NoMore := False;
              End;
        #73,
        #75 : Begin
                If QuoteTopPage > 6 Then
                  Dec (QuoteTopPage, 6)
                Else Begin
                  QuoteTopPage := 1;
                  QuoteCurLine := 0;
                End;
                NoMore := False;
                UpdateWindow;
              End;
        #77,
        #80 : If QuoteTopPage + QuoteCurLine < QuoteLines Then Begin
                If QuoteCurLine = 5 Then Begin
                  Inc (QuoteTopPage);
                  UpdateWindow;
                End Else Begin
                  UpdateBar(False);
                  Inc (QuoteCurLine);
                  UpdateBar(True);
                End;
              End;
        #81 : Begin
                If QuoteLines <= 6 Then
                  QuoteCurLine := QuoteLines - QuoteTopPage
                Else
                If QuoteTopPage + 6 < QuoteLines - 6 Then
                  Inc (QuoteTopPage, 6)
                Else Begin
                  QuoteTopPage := QuoteLines - 5;
                  QuoteCurLine := 5;
                End;
                UpdateWindow;
              End;
      End;
    End Else
      Case Ch of
        #27 : Break;
        #13 : If (TotalLine < mysMaxMsgLines) and (Not NoMore) Then Begin
                Added := True;

                If QuoteTopPage + QuoteCurLine = QuoteLines Then NoMore := True;

                InsertLine (CurLine);
                MsgText[CurLine] := QText[QuoteTopPage + QuoteCurLine];
                Inc (CurLine);

                Term.OutRaw(Term.Attr2Ansi(TextColor, False));

                Temp1  := WinEnd;
                WinEnd := Term.ScreenInfo[1].Y;
                If CurLine - Scroll + WinStart + 4 >= WinEnd Then Begin
                  ScreenRefreshFull;
                  Scroll := CurLine;
                End Else Begin
                  Dec (CurLine);
                  ScreenRefreshPart;
                  Inc (CurLine);
                  Inc (CurY);
                End;
                WinEnd := Temp1;

                If QuoteTopPage + QuoteCurLine < QuoteLines Then
                  If QuoteCurLine = 5 Then Begin
                    Inc (QuoteTopPage);
                    UpdateWindow;
                  End Else Begin
                    UpdateBar(False);
                    Inc (QuoteCurLine);
                    UpdateBar(True);
                  End;
              End;
      End;
  Until TBBSCore(Term.Owner).ShutDown;
  Term.OutFull('|16');
  If (CurLine < mysMaxMsgLines) And Added Then Inc(CurLine);
End;

Procedure Commands;
Var
  Ch     : Char;
  Keys   : String[9];
  Prompt : String;
  Str    : String;
Begin
  Done   := False;
  Save   := False;
  Prompt := TBBSCore(Term.Owner).GetPrompt(103);
  Keys   := strWordGet(1, Prompt, ' ');

  Delete (Prompt, 1, 10);

  Repeat
    Term.OutFull (Prompt);

    Ch := Term.OneKey (Keys, True);

    If Ch = Keys[1] Then
      Term.OutFull(TBBSCore(Term.Owner).GetPrompt(104))
    Else
    If Ch = Keys[2] Then Begin
      If Forced Then Begin
        Term.OutFull(TBBSCore(Term.Owner).GetPrompt(105));
        Exit;
      End Else Begin
        Done := Term.GetYN(TBBSCore(Term.Owner).GetPrompt(106), False);
        Exit;
      End;
    End Else
    If Ch = Keys[3] Then
      Exit
    Else
    If Ch = Keys[4] Then Begin
      Term.OutFile ('fsedithelp');
      Exit;
    End Else
    If Ch = Keys[5] Then Begin
      If TBBSCore(Term.Owner).User.ThisUser.QuoteWindow Then
        QuoteWindow
      Else
        Quote;
      Exit;
    End Else
    If Ch = Keys[6] Then
      Exit
    Else
    If Ch = Keys[7] Then Begin
      Save := True;
      Done := True;
      Exit;
    End Else
    If Ch = Keys[8] Then Begin
//      Msg_Upload (CurLine);
//      TotalLine := CurLine;
      Exit;
    End Else
    If Ch = Keys[9] Then Begin
      Term.OutFull (TBBSCore(Term.Owner).GetPrompt(200));
      Str := Term.GetStr(60, 60, -1, Subj);
      If Str <> '' Then Subj := Str;
      Term.PromptInfo['B'] := Subj;
      Exit;
    End;
  Until TBBSCore(Term.Owner).ShutDown;
End;

Procedure keyPageUp;
Begin
  If CurLine > 1 Then Begin
    If LongInt(CurLine - (WinEnd - WinStart)) >= 1 Then
      Dec (CurLine, (WinEnd - WinStart))
    Else
      CurLine := 1;
    ScreenRefreshFull;
  End;
End;

Procedure keyPageDown;
Begin
  If CurLine < TotalLine Then Begin
    If CurLine + (WinEnd - WinStart) <= TotalLine Then
      Inc (CurLine, (Term.ScreenInfo[2].Y - Term.ScreenInfo[1].Y))
    Else
      CurLine := TotalLine;

    ScreenRefreshFull;
  End;
End;

Procedure keyEnd;
Begin
  CurX := Length(MsgText[CurLine]) + 1;
  If CurX > WrapPos Then CurX := WrapPos + 1;
  UpdateCursor;
End;

Procedure AddChar (Ch: Char);
Begin
  If InsertMode Then Begin
    Insert (Ch, MsgText[Curline], CurX);
    Term.OutRaw(Copy(MsgText[CurLine], CurX, Length(MsgText[CurLine])));
  End Else Begin
    If CurX > Length(MsgText[CurLine]) Then Inc(MsgText[CurLine][0]);
    MsgText[CurLine][CurX] := Ch;
    Term.OutRaw(Ch);
  End;
  Inc (CurX);
  UpdateCursor;
End;

Var
  A : Integer;
Begin
  QuoteCurLine := 0;
  QuoteTopPage := 1;

  CurLine := Lines;
  If Lines = 0 Then CurLine := 1;
  Done    := False;
  CurX    := 1;
  CurY    := WinStart;
  TotalLine := CurLine;

  Dec (WrapPos);

  For A := Lines + 1 to mysMaxMsgLines Do MsgText[A] := '';

  ScreenFullReDraw;

//  CurY            := Term.ScreenInfo[1].Y;
  Term.AllowArrow := True;

  Repeat
    Ch := Term.NewGetKey(0);
    If Term.IsArrow Then Begin
      Case Ch of
        #71 : Begin
                CurX := 1;
                UpdateCursor;
              End;
        #72 : keyUpArrow(False);
        #73 : keyPageUp;
        #75 : keyLeftArrow;
        #77 : keyRightArrow;
        #79 : keyEnd;
        #80 : keyDownArrow;
        #81 : keyPageDown;
        #82 : keyToggleInsert (True);
        #83 : If CurX <= Length(MsgText[CurLine]) Then Begin
                Delete (MsgText[CurLine], CurX, 1);
                Term.OutRaw(Copy(MsgText[CurLine], CurX, Length(MsgText[CurLine])) + ' ');
                UpdateCursor;
              End Else
              If CurLine < TotalLine Then
                If (MsgText[CurLine] = '') and (TotalLine > 1) Then Begin
                  DeleteLine (CurLine);
                  ScreenRefreshPart;
                End Else
                If TotalLine > 1 Then
                  If Length(MsgText[CurLine]) + Length(MsgText[CurLine + 1]) <= WrapPos Then Begin
                    MsgText[CurLine] := MsgText[CurLine] + MsgText[CurLine + 1];
                    DeleteLine (CurLine + 1);
                    ScreenRefreshPart;
                  End Else
                    For A := Length(MsgText[CurLine + 1]) DownTo 1 Do
                      If (MsgText[CurLine + 1][A] = ' ') and (Length(MsgText[CurLine]) + A <= WrapPos) Then Begin
                        MsgText[CurLine] := MsgText[CurLine] + Copy(MsgText[CurLine + 1], 1, A - 1);
                        Delete (MsgText[CurLine + 1], 1, A);
                        ScreenRefreshPart;
                      End;
      End;
    End Else
    Case Ch of
      ^A : keyLeftArrow;
      ^B : ScreenFullReDraw;
      ^D : keyRightArrow;
      ^E : keyUpArrow(False);
      ^F : Begin
             CurX := 1;
             UpdateCursor;
           End;
      ^G : keyEnd;
      ^H : keyBackSpace;
      ^I : If CurX <= WrapPos Then Begin
             Repeat
               If (CurX < WrapPos) and (CurX = Length(MsgText[CurLine]) + 1) Then
                 MsgText[CurLine] := MsgText[CurLine] + ' ';
               Inc (CurX);
             Until (CurX MOD 5 = 0) or (CurX = WrapPos);
             UpdateCursor;
           End;
      ^J : Begin
             MsgText[CurLine] := '';
             CurX := 1;
             UpdateCursor;
             Term.OutRaw(Term.AnsiClrEOL);
           End;
      ^K : {reserved/cut text};
      ^L,
      ^M : keyEnter;
      ^N : keyPageDown;
      ^O : Begin
             Term.OutFile('fsedithelp');
             ScreenFullReDraw;
           End;
      ^P : keyPageUp;
      ^R : {paste text};
      ^T : If CurX > 1 Then Begin
             While (CurX > 1) and (MsgText[CurLine][CurX] <> ' ') Do Dec(CurX);
             While (CurX > 1) and (MsgText[CurLine][CurX] =  ' ') Do Dec(CurX);
             While (CurX > 1) and (MsgText[CurLine][CurX] <> ' ') Do Dec(CurX);
             If CurX > 1 Then Inc (CurX);
             UpdateCursor;
           End;
      ^U : Begin
             While CurX < Length(MsgText[CurLine]) + 1 Do Begin
               Inc (CurX);
               If MsgText[CurLine][CurX] = ' ' Then Begin
                 If CurX < Length(MsgText[CurLine]) + 1 Then Inc(CurX);
                 Break;
               End;
             End;
             UpdateCursor;
           End;
      ^V : keyToggleInsert(True);
// this needs work
      ^W : If CurX > 1 Then Begin
             While (CurX > 1) And (MsgText[CurLine][CurX] <> ' ') Do keyBackSpace;
             While (CurX > 1) And (MsgText[CurLine][CurX] =  ' ') Do keyBackSpace;
             While (CurX > 1) And (MsgText[CurLine][CurX - 1] <> ' ') Do keyBackSpace;
           End;
      ^X : keyDownArrow;
      ^Y : Begin
             DeleteLine (CurLine);
             ScreenRefreshPart;
           End;
      ^[ : Begin
              Commands;
              If (Not Save) and (Not Done) Then ScreenFullReDraw;
              Term.AllowArrow := True;
            End;
      #32..
      #254: If Length(MsgText[CurLine]) >= WrapPos Then Begin
              If TotalLine < MaxLines Then Begin
                AddChar(Ch);
                TextReformat;
              End;
            End Else
            If (CurX = 1) and (Ch = '/') Then Begin
              Commands;
              If (Not Save) And (Not Done) Then ScreenFullReDraw;
              Term.AllowArrow := True;
            End Else
              AddChar(Ch);
    End;
  Until TBBSCore(Term.Owner).ShutDown or Done;

  Term.AllowArrow := False;

  If Save Then Begin
    A := TotalLine;
    While (MsgText[A] = '') and (A > 1) Do Begin
      Dec (A);
      Dec (TotalLine);
    End;
    Lines := TotalLine;
  End;

  AnsiEditor := (Save = True);
  Term.OutRaw(Term.AnsiGotoXY(1, TBBSCore(Term.Owner).User.ThisUser.ScreenSize));
End;

End.
