{$I M_OPS.PAS}

Unit BBS_Common;

Interface

{$I BBS_RECORDS.PAS}

Const
  mysMBasesDat = 'mbases.dat';
  mysFBasesDat = 'fbases.dat';
  mysBlackList = 'blacklist.txt';

Function  CheckBBSVersion  (Cfg: RecConfig) : Boolean;
Function  Strip_Security   (Str: String) : String;
Function  Replace_Security (Str: String; Sec: Byte) : String;
Function  strAddr2Str      (Addr: RecEchoMailAddr) : String;
Function  strStr2Addr      (Str: String; Var Addr: RecEchoMailAddr) : Boolean;
Function  ReadSauceInfo    (FN: String; Var Sauce: RecSauceInfo) : Boolean;

Var
  bbsConfig : recConfig;

Implementation

Uses
  m_FileIO,
  m_Strings;

Function CheckBBSVersion (Cfg: recConfig) : Boolean;
Begin
  Result := Not ((Cfg.VersionMajor <> mysVersionMajor) or (Cfg.VersionMinor <> mysVersionMinor));
End;

Function Strip_Security (Str: String) : String;
Begin
  Delete (Str, Pos('@S', Str), 2);
  Result := Str;
End;

Function Replace_Security (Str: String; Sec: Byte) : String;
Var
  A : Byte;
Begin
  A := Pos('@', Str);

  If A > 0 Then Begin
    Delete (Str, A, 2);
    Insert (strI2S(Sec), Str, A);
  End;

  Result := Str;
End;

Function strAddr2Str (Addr: RecEchoMailAddr) : String;
Begin
  Result := strI2S(Addr.Zone) + ':' + strI2S(Addr.Net) + '/' + strI2S(Addr.Node);

  If Addr.Point <> 0 Then Result := Result + '.' + strI2S(Addr.Point);
End;

Function strStr2Addr (Str : String; Var Addr: RecEchoMailAddr) : Boolean;
Var
  A     : Byte;
  B     : Byte;
  C     : Byte;
  Point : Boolean;
Begin
  Result := False;
  Point  := True;

  A := Pos(':', Str);
  B := Pos('/', Str);
  C := Pos('.', Str);

  If (A = 0) or (B = 0) Then Exit;

  If C = 0 Then Begin
    Point      := False;
    C          := Length(Str) + 1;
    Addr.Point := 0;
  End;

  Addr.Zone := strS2I(Copy(Str, 1, A - 1));
  Addr.Net  := strS2I(Copy(Str, A + 1, B - 1 - A));
  Addr.Node := strS2I(Copy(Str, B + 1, C - 1 - B));

  If Point Then Addr.Point := strS2I(Copy(Str, C + 1, Length(Str)));

  Result := True;
End;

Function ReadSauceInfo (FN: String; Var Sauce: RecSauceInfo) : Boolean;
Var
  DF  : File;
  Str : String;
  Res : LongInt;
Begin
  Result := False;

  Assign (DF, FN);

  If Not ioReset (DF, 1, fmReadWrite + fmDenyNone) Then Exit;
  If Not ioSeek  (DF, FileSize(DF) - 128) Then Begin
    Close (DF);
    Exit;
  End;

  ioBlockRead (DF, Sauce, 128, Res);
  Close (DF);

  Move (Sauce.ID[1], Str[1], 5);
  Str[0] := #05;

  Result := strWide2Str(Sauce.ID, 5) = 'SAUCE';
End;

End.
