/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_SUBCLIENT
#define __LCMD_SUBCLIENT

#include "lcmd/LCmdPanelsParent.h"
#include "lcmd/LCmdCmdContainer.h"

/**
 * The Sub-Client window is the window which acts as the parent
 * of both the Panels Parent Window and the Command Line Container.
 *
 * @author  Leif Erik Larsen
 * @since   1999.04.08
 */
class LCmdSubClient : public GWindow
{
   public:

      LCmdPanelsParent panelsParent;
      LCmdCmdContainer cmdcont;

   public:

      LCmdSubClient ( class LCmdMainWindow& parentWin );
      virtual ~LCmdSubClient ();

   public:

      /**
       * This method is used in some cases when it is needed to force
       * recalculation of all parts of the file panels.
       */
      void recalcAllPartsOfLayout ();

   public:

      /**
       * @param  toggle   True to show. False to hide. -1 to toggle
       *                  current state.
       */
      void setCommandLineVisible ( int toggle = true );

      /**
       * @param  toggle   True to show. False to hide. -1 to toggle
       *                  current state.
       */
      void setFilePanelsVisible ( int toggle );

      /**
       * @param  toggle   True to show. False to hide. -1 to toggle
       *                  current state.
       */
      void setFullScreenMode ( int toggle );
};

#endif // #ifndef __LCMD_SUBCLIENT
