/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "lcmd/LCmdSubClient.h"
#include "lcmd/LCmdMainWindow.h"

#include "glib/gui/GScrollbar.h"
#include "glib/gui/layout/GBorderLayout.h"

LCmdSubClient::LCmdSubClient ( LCmdMainWindow& parentWin )
              :GWindow(&parentWin, 
                       "Client", 
                       GString::Empty, 
                       WS2_OS2Y | WS2_IGNORE_COLORS_AND_FONT_PROFILE | WS2_USE_SAME_PROFILE_SECTION_NAME_AS_PARENT),
               panelsParent(*this, GBorderLayout::NORTH),
               cmdcont(*this, GBorderLayout::CENTER)
{
   setLayoutManager(new GBorderLayout(), true);
}

LCmdSubClient::~LCmdSubClient ()
{
}

void LCmdSubClient::recalcAllPartsOfLayout ()
{
   // Force file item positioning of both panels to recalculate
   LCmdFilePanel& leftPanel = LCmdFilePanel::GetLeftPanel();
   LCmdFilePanel& rightPanel = LCmdFilePanel::GetRightPanel();
   leftPanel.selectItem(LCmdFilePanel::NavigateHome);
   rightPanel.selectItem(LCmdFilePanel::NavigateHome);

   // Layout the children of ours.
   layout();
}

void LCmdSubClient::setCommandLineVisible ( int toggle )
{
   if (toggle == -1)
      cmdcont.cmdline.setVisible(!cmdcont.cmdline.isVisible());
   else
      cmdcont.cmdline.setVisible(toggle ? true : false);

   LCmdOptions& opt = LCmdOptions::GetOptions();
   if (!cmdcont.cmdline.isVisible())
      opt.panelsFullScreen = true;

   if (!opt.panelsAreVisible)
      opt.panelsAreVisible = true;

   // Redraw/resize everything, since visibility of command line has changed.
   layout();

   LCmdMainWindow& mwin = LCmdMainWindow::GetMainWindow();
   mwin.ensureFocusOK();
}

void LCmdSubClient::setFullScreenMode ( int toggle )
{
   bool cmdlineWasVisible = cmdcont.cmdline.isVisible();

   LCmdOptions& opt = LCmdOptions::GetOptions();
   if (toggle == -1)
      opt.panelsFullScreen = !opt.panelsFullScreen;
   else
      opt.panelsFullScreen = toggle ? true : false;

   if (!opt.panelsFullScreen)
      setCommandLineVisible(true);

   // Redraw/resize everything, since visibility of command line has changed
   layout();

   bool cmdlineIsVisible = cmdcont.cmdline.isVisible();

   // Some parts of the "screen" are not neccessary to update, so
   // make it validated. To prevent some unneccessary flashing.
   if (cmdlineWasVisible && cmdlineIsVisible)
      cmdcont.cmdline.validateAll(true);

   LCmdMainWindow& mwin = LCmdMainWindow::GetMainWindow();
   mwin.ensureFocusOK();
}

void LCmdSubClient::setFilePanelsVisible ( int toggle )
{
   LCmdOptions& opt = LCmdOptions::GetOptions();
   LCmdConsoleMonitor& mon = cmdcont.conmon; // Ditto.
   LCmdCmdLine& cmd = cmdcont.cmdline; // Ditto.

   if (toggle == -1)
      opt.panelsAreVisible = !opt.panelsAreVisible;
   else
      opt.panelsAreVisible = toggle ? true : false;

   // Redraw/resize everything, since visibility of panels has changed
   setVisible(false);
   layout();
   setVisible(true);

   // The command line is not necessary to repaint anyway, except if panels
   // are toggled off when Command Line was not visible at all.
   if (!opt.panelsFullScreen || opt.panelsAreVisible)
   {
      cmd.validateAll(true);
      mon.getHScrollbar().validateAll(true);
   }

   LCmdMainWindow& mwin = LCmdMainWindow::GetMainWindow();
   mwin.ensureFocusOK();
}
