/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "lcmd/LCmdFilePanelFilterOptions.h"

LCmdFilePanelFilterOptions::LCmdFilePanelFilterOptions ()
{
   resetToDefault();
}

void LCmdFilePanelFilterOptions::resetToDefault ()
{
   include = "*";
   hideArchive = false;
   hideReadOnly = false;
   hideHidden = true;
   hideSystem = true;
   showDirs = true;
   showFiles = true;
}

bool LCmdFilePanelFilterOptions::equals ( const LCmdFilePanelFilterOptions& filt )
{
   return include == filt.include &&
          exclude == filt.exclude &&
          hideArchive == filt.hideArchive &&
          hideHidden == filt.hideHidden &&
          hideSystem == filt.hideSystem &&
          hideReadOnly == filt.hideReadOnly &&
          showDirs == filt.showDirs &&
          showFiles == filt.showFiles;
}

