/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_FILEPANELCOLOROPTIONS
#define __LCMD_FILEPANELCOLOROPTIONS

#include "lcmd/LCmdAbstractOptions.h"
#include "glib/gui/GColor.h"

/**
 * The color options of a file panel window.
 *
 * @author  Leif Erik Larsen
 * @since   2000.01.19
 */
class LCmdFilePanelColorOptions : public LCmdAbstractOptions
{
   public:

      /** Color of main background area. */
      GColor itemBck;

      /** Background of tagged items that are not currently selected. */
      GColor itemBckMarked;

      /** Foreground color of directories. */
      GColor itemDirTxt;

      /** Foreground color of filenames. */
      GColor itemFileTxt;

      /** Foreground color of readonly filenames. */
      GColor itemReadOnlyTxt;

      /** Foreground color of hidden/system filenames. */
      GColor itemSysHiddenTxt;

      /** Foreground color of archive (zip, etc.) filenames. */
      GColor itemArchiveTxt;

      /** Background color of selected file in active file panel. */
      GColor itemSelectedBckActive;

      /** Background of tagged items that are currently selected in active file panel. */
      GColor itemSelectedBckActiveMarked;

      /** Background color of selected file in inactive file panel. */
      GColor itemSelectedBckInactive;

      /** Thin border of selected item in active panel. */
      GColor itemSelectedThinActive;

      /** Thin border of selected item in inactive panel. */
      GColor itemSelectedThinInactive;

      /** Background of active panel header area. */
      GColor headerActiveBck;

      /** Foreground of active panel header area. */
      GColor headerActiveTxt;

      /** Background of active panel header area when inside some virtual file system. */
      GColor headerActiveBckWhenInsideVfs;

      /** Foreground of active panel header area when inside some virtual file system. */
      GColor headerActiveTxtWhenInsideVfs;

      /** Background of inactive panel header area. */
      GColor headerInactiveBck;

      /** Foreground of inactive panel header area. */
      GColor headerInactiveTxt;

      /** Background of inactive panel header area when inside some virtual file system. */
      GColor headerInactiveBckWhenInsideVfs;

      /** Foreground of inactive panel header area when inside some virtual file system. */
      GColor headerInactiveTxtWhenInsideVfs;

   public:

      /**
       * Initiate all the options in the new object with their
       * respective default value.
       */
      LCmdFilePanelColorOptions ();

   public:

      /**
       * Reset all the options in the object with their
       * respective default value.
       */
      void resetToDefault ();
};

#endif // #ifndef __LCMD_FILEPANELCOLOROPTIONS
