/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "lcmd/LCmdDynaFileSearch.h"
#include "lcmd/LCmdFilePanelHeader.h"
#include "lcmd/LCmdFilePanelFrame.h"
#include "lcmd/LCmdMainWindow.h"

#include "glib/gui/event/GKeyMessage.h"
#include "glib/gui/event/GUserMessage.h"
#include "glib/gui/border/GLineBorder.h"

LCmdDynaFileSearch::LCmdDynaFileSearch ( LCmdFilePanelHeader& parentWin )
                   :GMultiLineEditor("DynaSearch",
                                     GString::Empty,
                                     parentWin,
                                     0,
                                     WS2_IGNORE_FONT_PROFILE,
                                     128,   // maxTextLength
                                     false, // wordWrap
                                     null,  // Use system default 3D-border
                                     false, // readOnly
                                     true,  // ignoreTab
                                     true), // useAsSingleLine
                    header(parentWin)
{
   setInsets(new GInsets(1, 2, 1, 2), true);
   setBorder(new GLineBorder(), true);

   // Set the initial and default color options. The font will always be
   // set to the same as of the headerbar window anyway, so there is no need
   // to set the initial font. (See {@link LCmdFilePanel#startDynamicSearch}.)
   defaultBackgroundColor = GColor::YELLOW;
   defaultForegroundColor = GColor::BLACK;
   setBackgroundColor(defaultBackgroundColor);
   setForegroundColor(defaultForegroundColor);
}

LCmdDynaFileSearch::~LCmdDynaFileSearch ()
{
}

void LCmdDynaFileSearch::onFocusKill ()
{
   GMultiLineEditor::onFocusKill();
   setVisible(false);
}

void LCmdDynaFileSearch::onFocusSet ()
{
   GMultiLineEditor::onFocusSet();
   if (!isVisible())
      sendUserMessage("ENSURE_FOCUS");
}

bool LCmdDynaFileSearch::onUserMessage ( GUserMessage& msg )
{
   GString id = msg.getParam1String();
   if (id == "ENSURE_FOCUS")
   {
      LCmdMainWindow& mwin = LCmdMainWindow::GetMainWindow();
      mwin.ensureFocusOK();
      return true;
   }
   else
   {
      return GMultiLineEditor::onUserMessage(msg);
   }
}

bool LCmdDynaFileSearch::onKeyDown ( const GKeyMessage& key )
{
   char chr = key.getCharacter();
   if (chr != '\0')
   {
      // A character key with or without the combination of any shift-key(s).
      if (key.isAltDown() && !key.isCtrlDown())
      {
         // Make ALT+SHIFT+X and ALT+X operate the same to the user
         // as when pressing just X.
         GString keyStr = GCharacter::ToString(chr);
         replaceSelection(keyStr);
         return true;
      }
   }

   return GMultiLineEditor::onKeyDown(key);
}

void LCmdDynaFileSearch::fireValueChangeListeners ()
{
   GMultiLineEditor::fireValueChangeListeners();

   // ---
   GString text = getText();
   LCmdFilePanel& panel = header.panelFrame.fpanel;
   int curSel = panel.getCurrentSelectedIndex();
   int idx = panel.findNextMatchingItem(text, curSel - 1);
   if (idx >= 0 && idx != curSel)
      panel.selectItem(idx);
}
