/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "lcmd/LCmdDlgGotoLine.h"

#include "glib/GProgram.h"
#include "glib/gui/GDialogPanel.h"
#include "glib/gui/event/GDialogMessage.h"
#include "glib/gui/GSpinner.h"

LCmdDlgGotoLine::LCmdDlgGotoLine ( int minLine, int maxLine, 
                                   int defaultLine, int cancelLine )
                :minLine(minLine),
                 maxLine(maxLine),
                 cancelLine(cancelLine),
                 selectedLine(cancelLine),
                 defaultLine(defaultLine)
{
}

LCmdDlgGotoLine::~LCmdDlgGotoLine ()
{
}

int LCmdDlgGotoLine::execute ( GWindow* parentWin )
{
   GProgram& prg = GProgram::GetProgram();
   GString darg = prg.executeDialog(parentWin, "DlgGotoLine", this);
   if (darg == "DLG_OK")
      return selectedLine;
   else
      return cancelLine;
}

bool LCmdDlgGotoLine::handleDialogMessage ( GDialogMessage& msg )
{
   GDialogPanel& dlg = msg.getDialog();
   switch (msg.getID())
   {
      case GM_INITDIALOG: 
      {
         GSpinner& spinner = dynamic_cast<GSpinner&>(dlg.getComponentByID("101"));
         spinner.setMinimumValue(minLine);
         spinner.setMaximumValue(maxLine);
         spinner.setValue(defaultLine);
         return true; 
      }

      case GM_COMMAND: 
      {
         GString cmdID = msg.getParam1String();
         if (cmdID == "DLG_OK")
         {
            GSpinner& spinner = dynamic_cast<GSpinner&>(dlg.getComponentByID("101"));
            int line = spinner.getCurrentValue();
            if (line < minLine || line > maxLine)
            {
               GStringl msg("Line number must be %d - %d.", GVArgs(minLine).add(maxLine));
               dlg.showMessageBox(msg, GMessageBox::TYPE_ERROR);
            }
            else
            {
               selectedLine = line;
               dlg.dismiss(cmdID);
            }
         }
         else
         if (cmdID == "DLG_CANCEL")
         {
            dlg.dismiss(cmdID);
         }
         return true; 
      }

      default:
         return false;
   }
}

