/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_DLGFILETIME
#define __LCMD_DLGFILETIME

#include "lcmd/LCmdDirProgressBase.h"

#include "glib/util/GTimeStamp.h"

/**
 * This dialog is used by the command "File Date/Time".
 * The command ID is <i>cmdChooseFileTime</i>.
 *
 * @since   2000.07.14
 * @author  Leif Erik Larsen
 */
class LCmdDlgFileTime : public LCmdDirProgressBase
{
   private:

      /** Date and time when the file was last written/updated. */
      GTimeStamp timeWrite;

   public:

      explicit LCmdDlgFileTime ( class LCmdFilePanel& panel );
      virtual ~LCmdDlgFileTime ();

   protected:

      /**
       * Change the timestamp of the specified file or directory item.
       *
       * Assume that the file name is not "." nor "..",
       * and that "bSkipped" will contain false upon entry.
       */
      virtual bool handleFileItem ( class LCmdFileItem *pFile, int fileIndex, bool *bSkipped, bool *itemUpdated );

   private:

      /**
       * This is the message handler method that is called to handle
       * messages from the dialog box window.
       */
      bool handleDialogMessage ( class GDialogMessage& msg );

   public:

      /**
       * Create dialog box of where user can specify time stamp attributes.
       * Then, if user doesn't cancel the dialog box, execute the secondary
       * thread of which to perform the update of files.
       */
      void execute ();
};

#endif // #ifndef __LCMD_DLGFILETIME
