/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "lcmd/LCmdDlgFileFilterProperties.h"

#include "glib/GProgram.h"
#include "glib/gui/GDialogPanel.h"
#include "glib/gui/event/GDialogMessage.h"

LCmdDlgFileFilterProperties::LCmdDlgFileFilterProperties ()
                            :inclFiles(true),
                             inclDirs(true),
                             flagArchive(2),
                             flagReadOnly(2),
                             flagHidden(2),
                             flagSystem(2),
                             useInclFilterStr(false),
                             useExclFilterStr(false)
{
}

LCmdDlgFileFilterProperties::~LCmdDlgFileFilterProperties () 
{
}

bool LCmdDlgFileFilterProperties::userEditFilterOptions ( GWindow& parentWin )
{
   GProgram& prg = GProgram::GetProgram();
   GString darg = prg.executeDialog(&parentWin, "DlgFileFilterProperties", this);
   return darg == "DLG_OK";
}

bool LCmdDlgFileFilterProperties::handleDialogMessage ( GDialogMessage& msg )
{
   GDialogPanel& dlg = msg.getDialog();
   switch (msg.getID())
   {
      case GM_INITDIALOG:
      {
         dlg.setComponentValue("102", inclFiles);
         dlg.setComponentValue("103", inclDirs);
         dlg.setComponentValue("107", flagArchive);
         dlg.setComponentValue("104", flagReadOnly);
         dlg.setComponentValue("105", flagHidden);
         dlg.setComponentValue("106", flagSystem);
         dlg.setComponentValue("113", useInclFilterStr);
         dlg.setComponentValue("109", inclFilterStr);
         dlg.setComponentValue("110", useExclFilterStr);
         dlg.setComponentValue("111", exclFilterStr);
         return true;
      }

      case GM_CTRLCHANGED: 
      {
         // Make sure that at least one of the toggles "Files" and
         // "Directories" is on.
         GString ctrlID = msg.getParam1String();
         if (ctrlID == "102")
         {
            if (!msg.getParam2Bool())
               dlg.setComponentValue("103", true);
         }
         else
         if (ctrlID == "103")
         {
            if (!msg.getParam2Bool())
               dlg.setComponentValue("102", true);
         }
         return true; 
      }

      case GM_COMMAND: 
      {
         GString cmdID = msg.getParam1String();
         if (cmdID == "DLG_OK")
         {
            inclFiles = dlg.getComponentBoolValue("102");
            inclDirs = dlg.getComponentBoolValue("103");
            flagArchive = dlg.getComponentIntValue("107");
            flagReadOnly = dlg.getComponentIntValue("104");
            flagHidden = dlg.getComponentIntValue("105");
            flagSystem = dlg.getComponentIntValue("106");
            useInclFilterStr = dlg.getComponentBoolValue("113");
            inclFilterStr = dlg.getComponentValue("109");
            useExclFilterStr = dlg.getComponentBoolValue("110");
            exclFilterStr = dlg.getComponentValue("111");
            dlg.dismiss(cmdID);
         }
         else
         if (cmdID == "DLG_CANCEL")
         {
            dlg.dismiss(cmdID);
         }
         return true; 
      }

      default:
         return false;
   }
}
