/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_DLGCOPYFILE
#define __LCMD_DLGCOPYFILE

#include "glib/gui/event/GDialogMessageHandler.h"
#include "lcmd/LCmdCopy.h"

/**
 * This dialog is used to let the user specify the destination
 * of a file copy or move operation.
 *
 * @since   2000.06.21
 * @author  Leif Erik Larsen
 */
class LCmdDlgCopyFile : public GDialogMessageHandler
{
   private:

      LCmdCopy::SpecifyDestDir* dest;
      class GDialogFrame* dlgFrame;

   public:

      explicit LCmdDlgCopyFile ();
      virtual ~LCmdDlgCopyFile ();

   private:

      /**
       * This is the message handler method that is called to handle
       * messages from the dialog box window.
       */
      bool handleDialogMessage ( class GDialogMessage& msg );

   public:

      /**
       * Execute the modal dialog.
       */
      void execute ( class GWindow& parentWin, LCmdCopy::SpecifyDestDir& dest );
};

#endif // #ifndef __LCMD_DLGCOPYFILE
