/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "lcmd/LCmdCmdLine.h"
#include "lcmd/LCmdCmdLinePrompt.h"
#include "lcmd/LCmdCmdContainer.h"
#include "lcmd/LCmdOptions.h"

#include "glib/util/GMath.h"
#include "glib/gui/layout/GBorderLayout.h"
#include "glib/gui/border/GLineBorder.h"

LCmdCmdLine::LCmdCmdLine ( LCmdCmdContainer& ownerCont, 
                           const GString& constraints, 
                           LCmdConsoleMonitor& conmon )
            :GAbstractToolbarWindow("CmdLine", 
                                    constraints, 
                                    ownerCont, 
                                    true),
             initialized(false),
             ownerCont(ownerCont),
             conmon(conmon),
             prompt((LCmdCmdLinePrompt&) *addButton(new LCmdCmdLinePrompt(*this, GBorderLayout::WEST))),
             entry(*this, GBorderLayout::CENTER),
             butt((LCmdCmdLineButton&) *addButton(new LCmdCmdLineButton(*this, "CmdHist", GBorderLayout::EAST, "cmdCommandHistory", "", "IDP_TBCMDHIST", "")))
{
   setInsets(new GInsets(2, 2, 2, 2), true);
   setBorder(new GLineBorder(), true);

   // Make the tooltip occur above (not below) buttons, since the command 
   // line is typically located at the bottom of the "screen".
   setTooltipPosition(GTooltip::PosAbove);

   // Now, the constrictor has finished.
   initialized = true;
}

LCmdCmdLine::~LCmdCmdLine ()
{
}

int LCmdCmdLine::getPreferredHeight () const
{
   LCmdOptions& opt = LCmdOptions::GetOptions();
   if (opt.panelsAreVisible && !isVisible())
      return 0;

   const GInsets& ins = getInsets();
   const GInsets& entryIns = entry.getInsets();
   int promptH = prompt.getPreferredHeight();
   int entryH = entry.getHeightOfString("X") + entryIns.bottom + entryIns.top;
   int buttH = butt.getPreferredHeight();
   return GMath::Max(promptH, GMath::Max(entryH, buttH)) + ins.bottom + ins.top;
}

void LCmdCmdLine::currentPathHasChanged ()
{
   prompt.updatePromptText();
   if (isVisible())
      layout();
}

void LCmdCmdLine::layout ()
{
   if (!initialized)
      return;

   LCmdOptions& opt = LCmdOptions::GetOptions();
   if (opt.panelsAreVisible && !isVisible())
      return;

   GDimension dim = getWindowSize();
   if (dim.width <= 0 || dim.height <= 0)
      return;

   const GInsets& ins = getInsets();
   int top = dim.height - ins.top;
   int bottom = ins.bottom;
   int left = ins.left;
   int right = dim.width - ins.right;

   // East.
   int buttw = butt.getPreferredWidth();
   butt.setWindowBounds(right - buttw, bottom, buttw, top - bottom);
   right -= buttw;

   // West.
   int promptw = prompt.getPreferredWidth();
   prompt.setWindowBounds(left, bottom, promptw, top - bottom);
   left += promptw;

   // Center.
   int entryw = right - left;
   int entryh = top - bottom - 2;
   entry.setWindowBounds(left, bottom+1, entryw, entryh);

   // ---
   invalidateAll(true);
}
