/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/vfs/GVfsPool.h"
#include "glib/exceptions/GNoSuchElementException.h"
#include "glib/exceptions/GIllegalStateException.h"

GVfsPool::GVfsPool ()
{
}

GVfsPool::~GVfsPool ()
{
}

GVfs& GVfsPool::getVfs ( const GString& path )
{
   GObject::Synchronizer synch(pool);
   GVfs* vfs = pool.get(path);
   if (vfs == null)
      gthrow_(GNoSuchElementException(path));
   return *vfs;
}

void GVfsPool::putVfs ( const GString& path, GVfs* vfs )
{
   GObject::Synchronizer synch(pool);
   if (pool.containsKey(path))
      gthrow_(GIllegalStateException("VFS already contained in pool: " + path));
   pool.put(path, vfs, true);
}
