/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include <time.h>
#include "glib/util/GTimeStamp.h"
#include "glib/GProgram.h"

GTimeStamp::GTimeStamp ()
           :date(0, 0, 0),
            time(0, 0, 0)
{
   DATETIME dt;
   DosGetDateTime(&dt);
   time.setHours(dt.hours);
   time.setMinutes(dt.minutes);
   time.setSeconds(dt.seconds);
   time.setMillis(dt.hundredths * 10);
   date.setYear(dt.year);
   date.setMonth(dt.month);
   date.setDay(dt.day);
}

GTimeStamp::GTimeStamp ( const GDate& date, const GTime& time )
           :date(date),
            time(time)
{
}

GTimeStamp::GTimeStamp ( const FDATE& date, const FTIME& time )
           :date(date),
            time(time)
{
}

GTimeStamp::~GTimeStamp ()
{
}

const GTimeStamp& GTimeStamp::operator= ( const GTimeStamp& t )
{
   date = t.date;
   time = t.time;
   return *this;
}

GTimeStamp& GTimeStamp::set ( const FDATE& date, const FTIME& time )
{
   this->date = date;
   this->time = time;
   return *this;
}

bool GTimeStamp::operator< ( const GTimeStamp& t ) const
{
   if (date != t.date)
      return date < t.date;
   else
      return time < t.time;
}

bool GTimeStamp::operator> ( const GTimeStamp& t ) const
{
   if (date != t.date)
      return date > t.date;
   else
      return time > t.time;
}

bool GTimeStamp::operator== ( const GTimeStamp& t ) const
{
   return date == t.date && time == t.time;
}

bool GTimeStamp::operator<= ( const GTimeStamp& t ) const 
{ 
   return operator<(t) || operator==(t); 
}

bool GTimeStamp::operator>= ( const GTimeStamp& t ) const 
{ 
   return operator>(t) || operator==(t); 
}

bool GTimeStamp::operator!= ( const GTimeStamp& t ) const 
{ 
   return !operator==(t); 
}

void GTimeStamp::clear ()
{
   date.clear();
   time.clear();
}

GString GTimeStamp::getTimeStampString ( bool inclSeconds, const GLocaleData* locale ) const
{
   if (locale == null)
   {
      const GProgram& prg = GProgram::GetProgram();
      locale = &prg.getLocaleData();
   }

   GString ret = locale->getDateString(date);
   ret += ' ';
   ret += locale->getTimeString(time, inclSeconds);
   return ret;
}

GString GTimeStamp::toString () const
{
   return getTimeStampString(true, null);
}

const GDate& GTimeStamp::getDate () const 
{ 
   return date; 
}

const GTime& GTimeStamp::getTime () const 
{ 
   return time; 
}

int GTimeStamp::getYear () const 
{ 
   return date.getYear(); 
}

int GTimeStamp::getMonth () const 
{ 
   return date.getMonth(); 
}

int GTimeStamp::getDay () const 
{ 
   return date.getDay(); 
}

int GTimeStamp::getHours () const 
{ 
   return time.getHours(); 
}

int GTimeStamp::getMinutes () const 
{ 
   return time.getMinutes(); 
}

int GTimeStamp::getSeconds () const 
{ 
   return time.getSeconds(); 
}

int GTimeStamp::getMillis () const 
{ 
   return time.getMillis(); 
}

void GTimeStamp::setYear ( int val ) 
{ 
   date.setYear(val); 
}

void GTimeStamp::setMonth ( int val ) 
{ 
   date.setMonth(val); 
}

void GTimeStamp::setDay ( int val ) 
{ 
   date.setDay(val); 
}

void GTimeStamp::setHours ( int val ) 
{ 
   time.setHours(val); 
}

void GTimeStamp::setMinutes ( int val ) 
{ 
   time.setMinutes(val); 
}

void GTimeStamp::setSeconds ( int val ) 
{ 
   time.setSeconds(val); 
}

void GTimeStamp::setMillis ( int val ) 
{ 
   time.setMillis(val); 
}

void GTimeStamp::setDate ( int year, int month, int day ) 
{ 
   date.setDate(year, month, day); 
}

void GTimeStamp::setDate ( const GDate& date ) 
{ 
   this->date = date; 
}

void GTimeStamp::setTime ( int hour, int min, int sec, int ms ) 
{ 
   time.setTime(hour, min, sec, ms); 
}

void GTimeStamp::setTime ( const GTime& time ) 
{ 
   this->time = time; 
}

GString GTimeStamp::getDateString ( const GLocaleData* locale ) const 
{ 
   return date.getDateString(locale); 
}

GString GTimeStamp::getTimeString ( bool inclSeconds, const GLocaleData* locale ) const 
{ 
   return time.getTimeString(inclSeconds, locale); 
}
