/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/resource/GRcToken.h"

GRcToken::GRcToken ()
         :tokenStr(128),
          quoteChar('"'),
          quoted(false)
{
}

GRcToken::GRcToken ( const GString& token )
         :tokenStr(token),
          quoteChar('"'),
          quoted(token.containsWhiteSpace())
{
}

GRcToken::GRcToken ( const GRcToken& src )
         :tokenStr(src.tokenStr),
          quoteChar(src.quoteChar),
          quoted(src.quoted)
{
}

GRcToken::~GRcToken ()
{
}

GRcToken& GRcToken::operator= ( const GRcToken& src )
{
   if (&src == this)
      return *this;
   tokenStr = src.tokenStr;
   quoteChar = src.quoteChar;
   quoted = src.quoted;
   return *this;
}

bool GRcToken::operator== ( const GString& str ) const 
{ 
   return tokenStr == str; 
}

bool GRcToken::operator!= ( const GString& str ) const 
{ 
   return !operator==(str); 
}

GRcToken& GRcToken::operator+= ( char chr )
{ 
   tokenStr += chr; 
   return *this;
}

GRcToken::operator const char* () const 
{ 
   return tokenStr.cstring(); 
}

void GRcToken::clear ()
{
   tokenStr.clear();
   quoteChar = '"';
   quoted = false;
}

bool GRcToken::isQuoted () const 
{ 
   return quoted; 
}

char GRcToken::getQuoteCharacter () const 
{ 
   return quoteChar; 
}

char GRcToken::getCharacter ( int idx ) const 
{ 
   return tokenStr[idx]; 
}

bool GRcToken::isEmpty () const 
{ 
   return tokenStr.length() == 0 && !quoted; 
}

int GRcToken::getLength () const 
{ 
   return tokenStr.length(); 
}

GString GRcToken::toString () const 
{ 
   return tokenStr; 
}

const GString& GRcToken::getString () const 
{ 
   return tokenStr; 
}

