/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_MENUPOPUPPARAMS
#define __GLIB_MENUPOPUPPARAMS

#include "glib/resource/GMenuItemParams.h"
#include "glib/util/GArray.h"

/**
 * Each menu POPUP is reprsented with an instance of this class.
 */
class GMenuPopupParams : public GMenuItemParams
{
   friend class GMenuResource;

   public:

      GArray<GMenuItemParams> items;

   public:

      explicit GMenuPopupParams ( const GString& id );
      virtual ~GMenuPopupParams ();

   private:

      GMenuPopupParams ();

      /** Disable the copy constructor. */
      GMenuPopupParams ( const GMenuPopupParams& src ) {}

      /** Disable the assignment operator. */
      GMenuPopupParams& operator= ( const GMenuPopupParams& ) { return *this; }

   public:

      /**
       * @author  Leif Erik Larsen
       * @since   2000.09.08
       * @param   tokenizer   The tokenizer of where to get tokens to parse.
       * @throws  GRcException in case of any error.
       */
      virtual void loadFromScript ( class GRcTokenizer& tokenizer, 
                                    class GResourceTable* table );

      int MenParse_Popup ( class GRcCompiler& rc, 
                           int* piMenu, 
                           char* pcWord );
};

#endif


