/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_MENUITEMPARAMS
#define __GLIB_MENUITEMPARAMS

#include "glib/gui/event/GAbstractCommand.h"

/**
 * Each menu ITEM is reprsented with an instance of this class.
 */
class GMenuItemParams : public GAbstractCommand
{
   friend class GMenuResource;
   friend class GMenuPopupParams;
   friend class GMenuSeparatorParams;

   public:

      /**
       * Different types of menu items.
       */
      enum Type
      {
         /** Command item. */
         ITEM = 0,

         /** Door to a new popup menu. */
         POPUP,

         /** Horizontal separator line (without id). */
         SEPARATOR
      };

   public:

      /** Text ID, which is possibly initially a link to another TEXT. */
      GString textID;

      /** Hint ID, which is possibly initially a link to another TEXT. */
      GString hintID;

      /** Icon ID. */
      GString iconID;

      /** ID of which accelerator's key to display in menu. */
      GString accelKeyID;

      /** True if TEXT parameter was defined. */
      bool textIsDef;

      /** True if HINT parameter was defined. */
      bool hintIsDef;

      /** True if ICON parameter was defined. */
      bool iconIsDef;

      /** True if KEY parameter was defined. */
      bool keyIsDef;

      /** True if USERDATA parameter was defined. */
      bool userDataIsDef;

      /** True=hidden, false=visible. */
      bool iHide;

      /** True=disabled/locked, false=enabled. */
      bool iLock;

      /** ITEM, POPUP or SEPARATOR. */
      Type iType;

   public:

      /**
       * Create a new Menu Item with the specified ID.
       */
      explicit GMenuItemParams ( const GString& id );
      virtual ~GMenuItemParams ();

   private:

      GMenuItemParams ();

   public:

      /**
       * Parse the current "item" statement.
       *
       * @author  Leif Erik Larsen
       * @since   2000.09.08
       * @param   tokenizer   The tokenizer of where to get tokens to parse.
       * @throws  GRcException in case of any error.
       */
      virtual void loadFromScript ( class GRcTokenizer& tokenizer, class GResourceTable* table );
};

#endif


