/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_APTR
#define __GLIB_APTR

#include "glib/primitives/GObject.h"

/**
 * Since there are still a number of compilers not providing the 
 * <i>auto_ptr</i> template by default (and also because there is still 
 * some instability in its interface standard) we are better defining 
 * our own substitution.
 *
 * @author  Leif Erik Larsen
 * @since   2000.09.01
 */
template <class X> class aptr
{
   private:

      X* ptr;
      mutable bool owns;

   public:

      explicit aptr ( X* p = null ) : ptr(p), owns(p != null)
      {
      }

      aptr ( const aptr<X>& a ) : ptr(a.ptr), owns(a.owns)
      {
         a.owns = false;
      }

      virtual ~aptr ()
      {
         if (owns)
            delete ptr;
      }

   public:

      aptr<X>& operator= ( const aptr<X>& a )
      {
         if (&a != this)
         {
            if (owns)
               delete ptr;
            owns = a.owns;
            ptr = a.ptr;
            a.owns = false;
         }
         return *this;
      }

      operator X& () const { return *ptr; }
      X& operator*() const { return *ptr; }
      X* operator->() const { return ptr; }

      X* get () const
      {
         return ptr;
      }

      X* release () const
      {
         owns = false;
         return ptr;
      }
};

#endif
