/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include <limits.h>
#include "glib/primitives/GShort.h"

const short GShort::MIN_VALUE = SHRT_MIN;
const short GShort::MAX_VALUE = SHRT_MAX;

GShort::GShort () 
       :value(0) 
{
}

GShort::GShort ( const GShort& val ) 
       :value(val.value) 
{
}

GShort::GShort ( short val ) 
       :value(val) 
{
}

GShort::~GShort ()
{
}

int GShort::hashCode () const
{
   return value;
}

bool GShort::equals ( const GObject& obj ) const
{
   if (&obj == this)
      return true;
   const GShort* o = dynamic_cast<const GShort*>(&obj);
   if (o != null)
      return value == o->value;
   return false;
}

short GShort::ParseShort ( const GString& str, short radix )
{
   return GIntegerNumber<short>::ParseSigned(str, MIN_VALUE, MAX_VALUE, radix);
}

GString GShort::toString () const
{
   return GIntegerNumber<short>::ToSignedString(value);
}

GString GShort::ToString ( short value, short radix, int width, char padChar )
{
   return GIntegerNumber<short>::ToSignedString(value, radix, width, padChar);
}
