/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/primitives/GRectangle.h"
#include "glib/primitives/GVArgs.h"

GRectangle::GRectangle ( int x, int y, int width, int height )
           :x(x),
            y(y),
            width(width),
            height(height)
{
}

GRectangle::GRectangle ( const GRectangle& rect )
           :x(rect.x),
            y(rect.y),
            width(rect.width),
            height(rect.height)
{
}

GRectangle::GRectangle ()
           :x(0),
            y(0),
            width(0),
            height(0)
{
}

GRectangle::GRectangle ( const GDimension& dim )
           :x(0),
            y(0),
            width(dim.width),
            height(dim.height)
{
}

GRectangle::~GRectangle ()
{
}

GRectangle& GRectangle::operator= ( const GRectangle& rect ) 
{ 
   if (&rect == this)
      return *this;
   x = rect.x;
   y = rect.y;
   width = rect.width;
   height = rect.height;
   return *this;
}

bool GRectangle::operator== ( const GRectangle& rect ) 
{ 
   if (this == &rect)
      return true;
   else
      return x == rect.x &&
             y == rect.y &&
             width == rect.width &&
             height == rect.height;
}

bool GRectangle::operator!= ( const GRectangle& rect ) 
{ 
   return !operator==(rect); 
}

GRectangle& GRectangle::clear ()
{
   x = 0;
   y = 0;
   width = 0;
   height = 0;
   return *this;
}

bool GRectangle::equals ( const GRectangle& rect )
{
   if (this == &rect)
      return true;
   else
      return x == rect.x &&
             y == rect.y &&
             width == rect.width &&
             height == rect.height;
}

GRectangle& GRectangle::copyFrom ( const GRectangle& rect )
{
   if (&rect == this)
      return *this;
   x = rect.x;
   y = rect.y;
   width = rect.width;
   height = rect.height;
   return *this;
}

GRectangle& GRectangle::inflateRect ( int hor, int ver )
{
   x -= hor;
   y -= ver;
   width += 2 * hor;
   height += 2 * ver;
   return *this;
}

GRectangle& GRectangle::inflateRect ( int horver ) 
{ 
   return inflateRect(horver, horver); 
}

GRectangle& GRectangle::nudgeX ( int addX )
{
   x += addX;
   width -= addX;
   return *this;
}

GRectangle& GRectangle::nudgeY ( int addY )
{
   y += addY;
   height -= addY;
   return *this;
}

void GRectangle::setBounds ( int x, int y, int width, int height )
{
   this->x = x;
   this->y = y;
   this->width = width;
   this->height = height;
}

GString GRectangle::toString () const
{
   return GString("[x=%d, y=%d, width=%d, height=%d]", GVArgs(x).add(y).add(width).add(height));
}

bool GRectangle::isPointInRect ( int xpos, int ypos ) const
{
   return xpos >= x &&
          xpos < x + width &&
          ypos >= y &&
          ypos < y + height;
}
