/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_FLOAT
#define __GLIB_FLOAT

#include "glib/primitives/GFloatNumber.h"

/**
 * A general float representation class.
 *
 * @author  Leif Erik Larsen
 * @since   2000.10.23
 */
class GFloat : public GFloatNumber
{
   private:

      float value;

   public:

      static const float MIN_VALUE;
      static const float MAX_VALUE;

   public:

      GFloat () : value(0) {}
      GFloat ( const GFloat& val ) : value(val.value) {}
      GFloat ( float val ) : value(val) {}

      virtual ~GFloat ();

   public:

      operator float () const { return value; }

   public:

      virtual bool boolValue () const { return value == 0.0 ? false : true; }
      virtual char charValue () const { return char(int(value)); }
      virtual short shortValue () const { return short(int(value)); }
      virtual int intValue () const { return int(value); }
      virtual longlong longValue () const { return longlong(value); }
      virtual unsigned short ushortValue () const { return (unsigned short) value; }
      virtual unsigned int uintValue () const { return (unsigned int) value; }
      virtual ulonglong ulongValue () const { return ulonglong(value); }
      virtual float floatValue () const { return value; }
      virtual double doubleValue () const { return value; }

      virtual int hashCode () const;
      virtual bool equals ( const GObject& obj ) const;

   public:

      /**
       * Get the parsed float value of the specified string.
       *
       * @param  str    String of which to parse.
       * @return The parsed float value.
       * @throws GNumberFormatException if the specified string is not
       *                                possible to parse into a float.
       */
      static float ParseFloat ( const GString& str );

      /**
       * Return a <i>GString</i> representation of the current
       * float value.
       */
      virtual GString toString () const;

      /**
       * Convert the specified float value to a string.
       */
      static GString ToString ( float val );
};

#endif


