/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/primitives/GDimension.h"
#include "glib/primitives/GRectangle.h"
#include "glib/primitives/GString.h"

GDimension::GDimension ()
           :width(0),
            height(0)
{
}

GDimension::GDimension ( int width, int height )
           :width(width),
            height(height)
{
}

GDimension::GDimension ( const GDimension& dim )
           :width(dim.width),
            height(dim.height)
{
}

GDimension::~GDimension ()
{
}

GDimension& GDimension::clear ()
{
   width = 0;
   height = 0;
   return *this;
}

GDimension& GDimension::operator= ( const GDimension& d ) 
{ 
   if (&d == this)
      return *this;
   width = d.width;
   height = d.height;
   return *this;
}

GDimension& GDimension::copyFrom ( const GDimension& dim )
{
   if (&dim == this)
      return *this;
   width = dim.width;
   height = dim.height;
   return *this;
}

GDimension& GDimension::set ( int width, int height )
{
   this->width = width;
   this->height = height;
   return *this;
}

GString GDimension::toString () const
{
   GString str(16);
   str += '[';
   str += width;
   str += ',';
   str += height;
   str += ']';
   return str;
}


