/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/io/GInputStream.h"
#include "glib/GThread.h"

GString& GInputStream::readString ( GString& str ) const
{
   str.clear();

   for (;;)
   {
      int nextByte = readByte();
      if (nextByte <= -1) // If end of stream.
         break;
      unsigned char chr = (unsigned char) nextByte;
      str += chr;
      if (chr == '\n')
         break;
   }

   return str;
}

int GInputStream::read ( void* buff, int count ) const
{
   if (count <= 0)
      return 0;
   int countRead = 0;
   BYTE* ptr = (BYTE*) buff;
   for (int i=0; i<count; i++)
   {
      int nextByte = readByte();
      if (nextByte <= -1) // If end of stream.
         break;
      *ptr++ = BYTE(nextByte);
      countRead++;
   }
   if (countRead == 0)
      return -1; // End-of-stream.
   return countRead;
}

void GInputStream::readExact ( void* buff, int count ) const
{
   if (count <= 0)
      return;
   BYTE* byteBuff = (BYTE*) buff;
   int numReadTotal = 0;
   for (;;)
   {
      int numRead = read(byteBuff, count);
      if (numRead < 0)
      {
         // We have reached EOF.
         gthrow_(GIOException("Unexpected EOF"));
      }
      else
      if (numRead > 0)
      {
         numReadTotal += numRead;
         byteBuff += numRead;
         if (numReadTotal >= count)
            break;
         count -= numRead;
      }
      else
      {
         // Will this ever happen? Don't think so.
         GThread::Sleep(45); // Prevent the loop from hogging too much CPU.
      }
   }
}

