/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_TREEVIEWLISTENER
#define __GLIB_TREEVIEWLISTENER

#include "glib/primitives/GObject.h"

/**
 * An interface to be implemented by all classes that want to register
 * for Tree View events via {@link GTreeView#addTreeViewListener}.
 *
 * @author  Leif Erik Larsen
 * @since   2006.02.14
 */
class GTreeViewListener
{
   public:

      /**
       * This method is called when the specified node is about to be 
       * collapsed. Regardless if the collapse operation was initiated
       * by some user interactivity or by some application code.
       *
       * @author  Leif Erik Larsen
       * @since   2006.02.14
       * @param   node The tree node that is about to be collapsed.
       */
      virtual void treeNodeIsCollapsing ( class GTreeNode& node ) = 0;

      /**
       * This method is called when the specified node is about to be 
       * expanded. Regardless if the collapse operation was initiated
       * by some user interactivity or by some application code.
       *
       * @author  Leif Erik Larsen
       * @since   2006.02.14
       * @param   node The tree node that is about to be expanded.
       */
      virtual void treeNodeIsExpanding ( class GTreeNode& node ) = 0;

      /**
       * This method is called when the current selected node of the tree
       * view has been changed. Use method {@link GTreeView#getSelectedNode}
       * to get information about the new current selection.
       *
       * @author  Leif Erik Larsen
       * @since   2006.03.01
       */
      virtual void treeNodeSelectionHasChanged () = 0;
};

#endif
