/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_TREEMODELLISTENER
#define __GLIB_TREEMODELLISTENER

#include "glib/primitives/GObject.h"

/**
 * @author  Leif Erik Larsen
 * @since   2006.01.04
 */
class GTreeModelListener
{

public:

   /**
    * Invoked after a node (or a set of siblings) has changed in some
    * way. The node(s) have not changed locations in the tree or
    * altered their children arrays, but other attributes have
    * changed and may affect presentation. Example: the name of a
    * file has changed, but it is in the same location in the file
    * system.
    * 
    * To indicate the root has changed, childIndexes and children
    * will be null.
    * 
    * Use <code>e.getPath()</code> to get the parent of the changed node(s).
    * Use <code>e.getChildIndices()</code> to get the index(es) of the 
    * changed node(s).
    *
    * @author  Leif Erik Larsen
    * @since   2006.01.04
    */
   virtual void treeNodesChanged ( const class GTreeModelEvent& e ) = 0;

   /**
    * Invoked after nodes have been inserted into the tree.
    * 
    * Use <code>e.getPath()</code> to get the parent of the new node(s).
    * Use <code>e.getChildIndices()</code> to get the index(es) of the 
    * new node(s) in ascending order.
    *
    * @author  Leif Erik Larsen
    * @since   2006.01.04
    */
   virtual void treeNodesInserted ( const class GTreeModelEvent& e ) = 0;

   /**
    * Invoked after nodes have been removed from the tree. Note that
    * if a subtree is removed from the tree, this method may only be
    * invoked once for the root of the removed subtree, not once for
    * each individual set of siblings removed.
    *
    * Use <code>e.getPath()</code> to get the former parent of the 
    * deleted node(s). Use <code>e.getChildIndices()</code> to get
    * the index(es) the the node(s) had before being deleted,
    * in ascending order.
    *
    * @author  Leif Erik Larsen
    * @since   2006.01.04
    */
   virtual void treeNodesRemoved ( const class GTreeModelEvent& e ) = 0;
};

#endif
