/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_LAYOUTMANAGER
#define __GLIB_LAYOUTMANAGER

#include "glib/primitives/GString.h"
#include "glib/primitives/GDimension.h"

/**
 * Defines the interface for classes that know how to
 * layout Containers (Window or Dialog Panels).
 *
 * @author  Leif Erik Larsen
 * @since   2000.01.04
 */
class GLayoutManager : public GObject
{
   public:

      virtual ~GLayoutManager () { return; }

   public:

      /**
       * Calculates the preferred size for the specified panel given
       * its contained components.
       */
      virtual GDimension preferredLayoutSize ( class GWindow& parent ) = 0;

      /**
       * Calculates the preferred width for the specified panel given
       * its contained components.
       */
      virtual int preferredLayoutWidth ( class GWindow& parent ) = 0;

      /**
       * Calculates the preferred height for the specified panel given
       * its contained components.
       */
      virtual int preferredLayoutHeight ( class GWindow& parent ) = 0;

      /**
       * Lay out the container in the specified panel.
       */
      virtual void layoutWindow ( class GWindow& parent ) = 0;
};

#endif

