/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_BORDERLAYOUT
#define __GLIB_BORDERLAYOUT

#include "glib/gui/layout/GLayoutManager.h"

/**
 * Use this layout manager to layout a maximum of five children within one
 * parent, where each child is located either to the west, east, north,
 * south or center.
 *
 * @author  Leif Erik Larsen
 * @since   2000.01.05
 * @see     GWindow#setLayoutManager
 */
class GBorderLayout : public GLayoutManager
{
   public:

      static const GString CENTER;
      static const GString NORTH;
      static const GString SOUTH;
      static const GString WEST;
      static const GString EAST;

   public:

      GBorderLayout ();
      virtual ~GBorderLayout ();

   public:

      /**
       * @see GLayoutManager#preferredLayoutSize
       */
      GDimension preferredLayoutSize ( class GWindow& parent );

      /**
       * @see GLayoutManager#preferredLayoutWidth
       */
      int preferredLayoutWidth ( class GWindow& parent );

      /**
       * @see GLayoutManager#preferredLayoutHeight
       */
      int preferredLayoutHeight ( class GWindow& parent );

      /**
       * @see GLayoutManager#layoutWindow
       */
      void layoutWindow ( class GWindow& parent );
};

#endif

