/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_USERMESSAGE
#define __GLIB_USERMESSAGE

#include "glib/primitives/GString.h"

/**
 * This class is used when sending or posting a user defined message to 
 * the low level message handler of a window.
 *
 * @author  Leif Erik Larsen
 * @since   2003.12.01
 * @see     GWindow#sendUserMessage
 * @see     GWindow#sendUserMessage
 * @see     GWindow#GM_USERMESSAGE
 */
class GUserMessage : public GObject
{
   private:

      GObject* param1;
      GObject* param2;
      GObject* param3;
      GString* str1; // If param1 is a string, then this is != null.
      GString* str2; // If param2 is a string, then this is != null.
      bool autoDeleteParam1;
      bool autoDeleteParam2;
      bool autoDeleteParam3;

   public:

      GUserMessage ( GObject* param1 = null, 
                     GObject* param2 = null,
                     GObject* param3 = null );

      GUserMessage ( const GString& str1, 
                     GObject* param2 = null,
                     GObject* param3 = null );

      GUserMessage ( const GString& str1, 
                     const GString& str2,
                     GObject* param3 = null );

      virtual ~GUserMessage ();

   private:

      // Prevent any attempt to copy.
      GUserMessage ( const GUserMessage& src ) {}

      // Prevent any attempt to assign.
      GUserMessage& operator= ( const GUserMessage& ) { return *this; }

   public:

      GObject* getParam1 ();
      GObject* getParam2 ();
      GObject* getParam3 ();
      int getParam1Int ( int def = -1 ) const;
      int getParam2Int ( int def = -1 ) const;
      GString getParam1String ( const GString& def = GString::Empty ) const;
      GString getParam2String ( const GString& def = GString::Empty ) const;
      bool getParam1Bool ( bool def = false ) const;
      bool getParam2Bool ( bool def = false ) const;

      void setAutoDeleteParam1 ( bool autoDel );
      void setAutoDeleteParam2 ( bool autoDel );
      void setAutoDeleteParam3 ( bool autoDel );

      /**
       * Return a string representation of the user message object
       * that can be used in debug logging, etc.
       *
       * @author  Leif Erik Larsen
       * @since   2001.04.02
       */
      GString toString () const;
};

#endif
