/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_DRAGOVERANSWER
#define __GLIB_DRAGOVERANSWER

#include "glib/primitives/GObject.h"

/**
 *
 * @author  Leif Erik Larsen
 * @since   2007.01.07
 */
class GDragOverAnswer : public GObject
{

public:

   enum DRAGOVERANSWER_CANDROP
   {
      DOANSW_DROP      = DOR_DROP,      // Yes, I can receive the object(s)
      DOANSW_NODROP    = DOR_NODROP,    // No, I can not receive them now
      DOANSW_NODROPOP  = DOR_NODROPOP,  // No, I can not receive using the specified operation
      DOANSW_NEVERDROP = DOR_NEVERDROP  // No, I can not receive the object(s)
   };

   enum DRAGOVERANSWER_DEFAULTOP
   {
      DOANSW_COPY    = DO_COPY,         // By default, I will copy the object(s)
      DOANSW_LINK    = DO_LINK,         // By default, I will link to the object(s)
      DOANSW_MOVE    = DO_MOVE,         // By default, I will move the object(s)
      DOANSW_CREATE  = DO_CREATE,       // By default, I will create the object(s)
      DOANSW_UNKNOWN = DO_UNKNOWN       // Program defined default operation
   };

   /** Drag reply as to be returned by {@link GDragDropHandler#handleDragOver}. */
   DRAGOVERANSWER_CANDROP canDrop;
   DRAGOVERANSWER_DEFAULTOP defaultOp;
};

#endif
