/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_FLATBORDER
#define __GLIB_FLATBORDER

#include "glib/gui/border/GBorder.h"

/**
 * A flat border with a thin line with optional color.
 *
 * @author  Leif Erik Larsen
 * @since   2004.09.17
 */
class GLineBorder : public GBorder
{
   public:

      enum Align
      {
         /** Align thin line to the outer bounds of the rectangle insets. */
         AlignInner,

         /** Align thin line into the center of the rectangle inset bounds. */
         AlignCenter,

         /** Align thin line to the inner bounds of the rectangle insets. */
         AlignOuter,

         /** Use this alignment if you want the corresponding thin line to be hidden. */
         AlignInvisible
      };

   private:

      Align topAlign;
      Align bottomAlign;
      Align leftAlign;
      Align rightAlign;

      /** Color of the border background, or null to use the default. */
      class GColor* bckColor;

      /** Color of the thin line, or null to use the default. */
      class GColor* lineColor;

   public:

      /**
       * Create an empty border with the default colors.
       * The default border color is the current color of the graphics 
       * object when it is given to {@link #paintTheBorder}.
       * The color of the thin line (if visible) is fixed by default.
       *
       * @author  Leif Erik Larsen
       * @since   2004.09.17
       */
      GLineBorder ( Align alignAll = AlignInner );

      GLineBorder ( Align topAlign,
                    Align bottomAlign,
                    Align leftAlign,
                    Align rightAlign );

      virtual ~GLineBorder ();

   protected:

      /**
       * @author  Leif Erik Larsen
       * @since   2004.09.17
       */
      virtual void paintTheBorder ( class GGraphics& g,
                                    const class GRectangle& rect, 
                                    const class GInsets& ins ) const;

   public:

      /**
       * Set the background color of the border. The "backgropund" here 
       * means everything but the thin line.
       *
       * @author  Leif Erik Larsen
       * @since   2004.09.21
       */
      void setBackgroundColor ( const GColor& color );

      /**
       * Set the color of the thin line of the border.
       *
       * @author  Leif Erik Larsen
       * @since   2004.09.21
       */
      void setLineColor ( const GColor& color );
};

#endif
