/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_WALLPAPERPARAMS
#define __GLIB_WALLPAPERPARAMS

#include "glib/primitives/GString.h"

/**
 * This class is used by <i>GDialogPanel</i> to hold the parameters of
 * a wallpaper parameter set.
 *
 * @author  Leif Erik Larsen
 * @since   2000.01.23
 */
class GWallPaperParams : public GObject
{
   public:

      /**
       * Flags used to identify supported wallpaper fill options.
       */
      enum DWP_FLAG
      {
         DWP_TILEIMAGE,
         DWP_STRETCHIMAGE,
         DWP_CENTERIMAGE
      };

      /**
        * The name of the graphics file (gif, tiff or jpeg format).
        */
      GString fileName;

      /**
       * DWP_TILEIMAGE, DWP_STRETCHIMAGE or DWP_CENTERIMAGE.
       */
      DWP_FLAG flag;

      /**
       * True if the wallpaper is to be on (visible) or else false.
       */
      bool on;

   public:

      /**
       * Create a new wallpaper property.
       *
       * @param fileName The name of the graphics file (gif, tiff or jpeg format).
       * @param on       True if the wallpaper is to be on (visible) or else false.
       * @param flag     DWP_TILEIMAGE, DWP_STRETCHIMAGE or DWP_CENTERIMAGE.
       */
      GWallPaperParams ( const GString& fileName, bool on, DWP_FLAG flag );
      virtual ~GWallPaperParams ();

   public:

      GWallPaperParams& operator=  ( const GWallPaperParams& src );
};

#endif

