/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/GMenu.h"

GMenu::GMenu ( const GString& name,
               const GString& constraints,
               GWindow& parentWin,
               GMenuPopupParams* popup,
               bool useFancyMenues,
               bool isMenuBar,
               bool topMnemonicsOn )
      :GMenuPopup(name, 
                  constraints, 
                  *this, 
                  parentWin,
                  popup, 
                  topMnemonicsOn, 
                  0, 
                  true, 
                  isMenuBar),
       commandIDCounter(0),
       useFancyMenues(useFancyMenues),
       is_Menubar(isMenuBar)
{
   if (!isMenuBar)
   {
      // Use default font for menu bars, but for popup menues use this font.
      setFontNameSize("8.Helv");
   }

   GMenuPopup::init_(parentWin, popup, topMnemonicsOn);
}

GMenu::~GMenu ()
{
}

GMenuPopupItem* GMenu::getCommand ( int id )
{
   return commandMap.getCommand(id);
}

int GMenu::getCommandMapID ( const char* commandID )
{
   return commandMap.getCommandMapID(commandID);
}

void GMenu::setCommandEnableState ( const char* cmdID, bool state )
{
   int id = getCommandMapID(cmdID);
   if (id > 0)
   {
      WinEnableMenuItem(theWin.getHWND(), id, state);
   }
}

void GMenu::setCommandToggleState ( const char* cmdID, bool state )
{
   int id = getCommandMapID(cmdID);
   if (id > 0)
   {
      WinCheckMenuItem(theWin.getHWND(), id, state);
   }
}

bool GMenu::isMenubar () const 
{ 
   return is_Menubar; 
}

void GMenu::setUseFancyMenues ( bool fancy )
{
   if (fancy == useFancyMenues)
      return; // The requested state is already the active state.
   useFancyMenues = fancy;
   GMenuPopup::setUseFancyMenues(fancy);
}

void GMenu::showPopupMenu ( int xpos, int ypos )
{
   GWindow& win = getParentWindow();
   // Force the menu to be re-measured each time it is shown.
   // OS/2 by default send the WM_MEASUREITEM message only the first time.
   bool wasFancy = useFancyMenues;
   setUseFancyMenues(!wasFancy);
   setUseFancyMenues(wasFancy);
   // ---
   ypos = win.sysY(ypos);
   int flags = PU_NONE | PU_MOUSEBUTTON1 | PU_MOUSEBUTTON2 | PU_MOUSEBUTTON3 | PU_KEYBOARD | PU_HCONSTRAIN | PU_VCONSTRAIN;
   HWND winh = win.getHWND();
   ::WinPopupMenu(winh, winh, theWin.getHWND(), xpos, ypos, 0, flags);
}

GString GMenu::getFontNameSize () const
{
   return theWin.getFontNameSize();
}

void GMenu::setFontNameSize ( const GString& fontNameSize )
{
   theWin.setFontNameSize(fontNameSize);
   // Force the menu to be re-measured the next time it is shown.
   bool wasFancy = useFancyMenues;
   setUseFancyMenues(!wasFancy);
   setUseFancyMenues(wasFancy);
}

GString GMenu::userChooseFont ( const GString& titleText, 
                                bool setFont, 
                                GWindow* pwin, 
                                const GString& initialFont )
{
   return theWin.userChooseFont(titleText, setFont, pwin, initialFont);
}
