/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_ADDCOMPONENTEXCEPTION
#define __GLIB_ADDCOMPONENTEXCEPTION

#include "glib/exceptions/GException.h"

/**
 * This exception can be thrown by various methods that adds a child
 * window or component to a window or by window constructors that fails
 * to initialize the window object.
 *
 * One typical example of when this exception is thrown is by the
 * constructor of <i>GWindow</i> in case the specified window name is
 * already in use by some other child window.
 *
 * @author  Leif Erik Larsen
 * @since   1999.12.28
 */
class GAddComponentException : public GException
{
   public:

      explicit GAddComponentException ( const char* msg );
};

#endif


