/* --------------------------------------------------------------------------
 *
 * This file was part of the "More for C++" library.
 * Copyright (c) 1999-2003 by Thorsten Goertz.
 * The "More for C++" library is free software; you can
 * redistribute it and/or modify it under the terms of the license
 * that comes with http://www.morefor.org/.
 *
 * ------------------------------------------------------------------------ */

#ifndef BITMASK_HPP
#define BITMASK_HPP

class BitMask
{
public:
   typedef unsigned char byte;
   static size_t calcSize( size_t nNoOfBits );

   BitMask( byte* pBytesForBits = 0, size_t nNoOfBytes = 0, size_t nNoOfBits = 0 );
   void initialize( byte* pBytesForBits, size_t nNoOfBytes, size_t nNoOfBits );
   size_t getNoOfBits( ) const;
   void clear( );
   void setBit( size_t nIndex, bool bValue );
   bool getBit( size_t nIndex ) const;

private:
   byte*   m_pBytesForBits;
   size_t  m_nNoOfBytes;
   size_t  m_nNoOfBits;
};

#endif
