/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_CMDLINEPARAMETERS
#define __GLIB_CMDLINEPARAMETERS

#include "glib/util/GArray.h"

/**
 * General class to take a command line parameter string and parse it into
 * its separate parameters which are put into an accessable dynamic array of
 * parameters.
 *
 * This class is used to simplify the task of parsing the command line
 * parameters given by users.
 *
 * @author  Leif Erik Larsen
 * @since   1999.09.07
 */
class GCmdLineParameters : public GObject
{
   private:

      GArray<GString> params;

   public:

      GCmdLineParameters ( int argc, const char *args[] );
      explicit GCmdLineParameters ( const GString& paramsStr );
      virtual ~GCmdLineParameters ();

   private:

      /** Disable the copy constructor. */
      GCmdLineParameters ( const GCmdLineParameters& src ) {}

      /** Disable the assignment operator. */
      GCmdLineParameters& operator= ( const GCmdLineParameters& ) { return *this; }

   public:

      int getCount () const;
      const GString& getIndexedString ( int index ) const;
      bool getBoolean ( const GString& name, bool defval ) const;
      double getDouble ( const GString& name, double defval ) const;
      int getInteger ( const GString& name, int defval ) const;
      GString getString ( const GString& name, const GString& defval ) const;
      bool isContainingParam ( const GString& name, bool ignoreCase = true ) const;
      bool isContainingHelpRequest () const;
};

#endif

