// Locale support -*- C++ -*-

// Copyright (C) 1997-1999, 2000 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

//
// ISO C++ 14882: 22.1  Locales
//
  
// Information as gleaned from /emx/include/ctype.h

#define __ctype_ALNUM 	0x0001
#define __ctype_ALPHA	0x0002
#define __ctype_CNTRL	0x0004
#define __ctype_DIGIT	0x0008
#define __ctype_XDIGIT	0x0010
#define __ctype_PUNCT	0x0020
#define __ctype_UPPER	0x0040
#define __ctype_LOWER	0x0080
#define __ctype_GRAPH	0x0100
#define __ctype_PRINT	0x0200
#define __ctype_SPACE	0x0400
  
  struct ctype_base
  {
    // Non-standard typedefs.
    typedef const unsigned char*  __to_type;

    // NB: Offsets into ctype<char>::_M_table force a particular size
    // on the mask type. Because of this, we don't use an enum.
    typedef unsigned short mask;
    static const mask upper    	= __ctype_UPPER;
    static const mask lower 	= __ctype_LOWER;
    static const mask alpha 	= __ctype_ALPHA;
    static const mask digit 	= __ctype_DIGIT;
    static const mask xdigit 	= __ctype_XDIGIT;
    static const mask space 	= __ctype_SPACE;
    static const mask print 	= __ctype_PRINT;
    static const mask graph 	= __ctype_GRAPH;
    static const mask cntrl 	= __ctype_CNTRL;
    static const mask punct 	= __ctype_PUNCT;
    static const mask alnum 	= __ctype_ALNUM;
  };
