/************************************************************************/
/* Banner - Skript 										*/
/*   Ausgabe von Texten in groen Buchstaben sowie einer Verwaltung von Schriftarten  */
/*   Dieses Rexx-Skript dient dazu, neu generierte Schriftarten auerhalb von FleetStreet	*/
/*   testen zu knnen										*/
/*   Das Skript GENFONT dient zur Erstellung neuer Schriftarten				*/  
/*  												*/
/*   von Thomas Jachmann  (2:2490/1135.17)   -   Version 1.0  -   22.10.94 		*/	
/************************************************************************/
/* Aufbau einer Fontdatei:									*/
/*    Erste Zeile         : Beliebiger Name des Fonts, z.B. "Fantasy Italic"               */
/*    Zweite Zeile       : Abstand zwischen den Buchstaben (in Zeichen)                  */
/*    Jede weitere Zeile : Z_H_B_xxx							*/
/*            mit:  	Z: Genau ein Zeichen, da in dieser Zeile definiert werden soll	*/
/*			H: Hhe des Zeichens  (0 < H <= 9)					*/
/*			B: Breite des Zeichens (0 < B <= 8)					*/
/*			_: Leerzeichen (diese MSSEN eingehalten werden)			*/
/*		      xxx: Hexwerte, die das Zeichen definieren              		*/
/*  												*/
/*    Die Definition mu zu Beginn jeder Zeile stehen !!!					*/
/*  												*/
/*    Wollen Sie eignene Fonts definieren, mssen Sie sich jedoch nicht mit diesen 	*/
/*    Definitionen aufhalten, es existiert extra ein Rexx-Skript, da Sie bei der Generier-*/
/*    untersttzt ("GENFONT.CMD"). Sie mssen lediglich den Fontdateikopf von Hand 	*/
/*    ergnzen											*/
/************************************************************************/
/*    Wird die Ausgabe von Kleinbuchstaben gewnscht, so mssen die Schriftartdateien  */
/*    um diese ergnzt werden. Wird ein Kleinbuchstabe gewnscht, der sich nicht in der	*/
/*    Schriftartdatei befindet, so wird das Zeichen in einen Grobuchstaben konvertiert 	*/
/*    und erneut versucht, in zu finden, geht auch dies fehl, so wird eine Warnung ausge	*/
/*    geben und der Buchstabe bei der Ausgabe bergangen					*/
/************************************************************************/

/* !! Hier mu unter Umstnden der Font-Pfad  gendert werden !! */               
/* fontpfad = 'f:\rexx\fonts' 	*/	/* Absoluter Pfad in ein Font-Directory */
 fontpfad = '.\'	 		/* Relativer Pfad in das aktuelle Directory */
             
fontext  = '.fft'                               /* Endung fr Fontdateien */

/* Bibliothek installieren */
call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'

/* Verzeichnis nach Schriftartdateien durchsuchen */
ichsuchnach = fontpfad || '*' || fontext

call SysFileTree ichsuchnach, 'gefdateien', 'FO'

schriftanz = gefdateien.0

IF schriftanz = 0 THEN
  DO
  SAY 'Im eingestellten Verzeichnis befinden sich keine Schriftarten'
  EXIT
  END

/* Schriftart auswhlen */
SAY 'Bitte geben Sie die Nummer der gewnschten Schriftart ein: '

DO i = 1 TO schriftanz
   schriftart.i.dateiname = gefdateien.i
   schriftart.i.name = gefdateien.i

  IF STREAM(gefdateien.i, 'c', 'open read') = 'READY:' THEN
    DO
    schriftart.i.name = LINEIN(gefdateien.i)       /* Name der Schrift lesen */
    erg = STREAM(gefdateien.i, 'c', 'close')
    END

  SAY ' ' || i || ' - ' || schriftart.i.name
END 

CALL CHAROUT 'STDOUT', 'Welche Schriftart wnschen Sie (1 - ' || schriftanz || ') ? '
PARSE UPPER PULL schrift .

IF (DATATYPE(schrift) \= 'NUM') | (schrift <= 0) | (schrift > schriftanz) THEN
  DO
  SAY 'Fehler bei der Wahl der Schriftart'
  EXIT
  END

/* schriftart.schrift.dateiname und schriftart.schrift.name beinhalten nun die gltigen Werte */

IF STREAM(schriftart.schrift.dateiname, 'c', 'open read') \= 'READY:' THEN
  DO
  SAY 'Die Schriftdatei ''' schriftart.schrift.name ''' kann nicht gefunden werden'
  EXIT
  END

/* Eingabe des Textes */
CALL CHAROUT 'STDOUT', 'Welcher Text soll dargestellt werden ?   ---> '
PARSE PULL ausgabetext

SAY 'Mit welchem Zeichen sollen die Buchstaben dargestellt werden ? '
CALL CHAROUT 'STDOUT', '     (RETURN fr das immer jeweilige Zeichen)   ---> '
PARSE PULL zeichen .
zeichen = SUBSTR(zeichen,1,1,' ')		/* Leerzeichen steht fuer das jeweilige Zeichen */

/* Zeichenarray zurcksetzen */
zeichenarr. = -1

/* Bentigte Schriftartdatei lesen */
temp = LINEIN(schriftart.schrift.dateiname)                    /* Name der Schrift in der ersten Zeile berlesen */
zwraum = LINEIN(schriftart.schrift.dateiname)

IF (DATATYPE(zwraum) \= 'NUM') | (zwraum < 0) THEN
  DO
  SAY 'Der Zwischenraum der Schrift liegt auerhalb der erlaubten Grenzen'
  EXIT
  END

DO WHILE LINES(schriftart.schrift.dateiname) = 1
  aktnummer = C2D(CHARIN(schriftart.schrift.dateiname))             /* Zeichen */

  IF aktnummer \== 13 THEN
    DO
    temp = CHARIN(schriftart.schrift.dateiname)                             
    zeichenarr.aktnummer.hoehe = CHARIN(schriftart.schrift.dateiname)  /* Hhe des Zeichens */

    IF (DATATYPE(zeichenarr.aktnummer.hoehe) \= 'NUM') | (zeichenarr.aktnummer.hoehe <= 0) THEN
      DO
      SAY 'Die Hhe des Zeichens ' || D2C(aktnummer) || ' unterschreitet das Minimum !'
      EXIT
      END

    IF zeichenarr.aktnummer.hoehe > 9 THEN
      DO
      zeichenarr.aktnummer.hoehe = 9
      SAY 'Die Hhe des Zeichens ' || D2C(aktnummer) || ' wurde auf 9 begrenzt'
      END

    temp = CHARIN(schriftart.schrift.dateiname) 
    zeichenarr.aktnummer.breite = CHARIN(schriftart.schrift.dateiname)  /* Breite des Zeichens */

    IF (DATATYPE(zeichenarr.aktnummer.breite) \= 'NUM') | (zeichenarr.aktnummer.breite > 8) | (zeichenarr.aktnummer.breite <= 0) THEN
      DO
      SAY 'Die Breite des Zeichens ' || D2C(aktnummer) || ' befindet sich auerhalb des gltigen Bereiches'
      EXIT
      END

    temp = CHARIN(schriftart.schrift.dateiname)
    zeichenarr.aktnummer.zeichen = LINEIN(schriftart.schrift.dateiname) /* Hexstring einlesen */
    END
  ELSE
    temp = LINEIN(schriftart.schrift.dateiname)
END

/* Aufbereitung der Textausgabe */
i = 1
laenge = LENGTH(ausgabetext)
DO  WHILE i <= laenge
  aktzeichen = SUBSTR(ausgabetext, i, 1)
  aktnummer = C2D(aktzeichen)
  IF zeichenarr.aktnummer.hoehe < 0 THEN
    DO
    PARSE UPPER VAR aktzeichen grosszeichen     
    aktnummer = C2D(grosszeichen)
    IF zeichenarr.aktnummer.hoehe < 0 THEN
      DO
      /* undruckbares Zeichen entfernen */
      merker = ausgabetext
      ausgabetext = SUBSTR(merker, 1, i-1)
      IF i < LENGTH(merker) THEN
         ausgabetext = ausgabetext || SUBSTR(merker, i+1, LENGTH(merker)-i)
      laenge = laenge - 1

      IF zeichenarr.aktnummer.hoehe = -1 THEN
        IF grosszeichen == aktzeichen THEN
          SAY 'Sorry, ' || aktzeichen  || ' nicht im Zeichensatz definiert'
        ELSE
          SAY 'Sorry, weder ' || aktzeichen  || ' noch ' || grosszeichen || ' im Zeichensatz definiert'

      zeichenarr.aktnummer.hoehe = -2
      END
    ELSE
      DO
      /* kleiner Zeichen durch ein groes ersetzen */
      merker = ausgabetext
      ausgabetext = SUBSTR(merker, 1, i-1)
      merkzeich = SUBSTR(merker, i, 1)
      PARSE UPPER VAR merkzeich merkzeich
      ausgabetext = ausgabetext || merkzeich
      IF i < LENGTH(merker) THEN
         ausgabetext = ausgabetext || SUBSTR(merker, i+1, LENGTH(merker)-i)
      i = i + 1
      END
  END
ELSE
  i = i + 1
END

/* Nun liegt eine Zeichenkette vor, die nur noch aus druckbaren Zeichen besteht */

/* Maximale Hoehe der Zeichen bestimmen */
maxhoehe = 0
DO i = 1 to LENGTH(ausgabetext)
  aktnummer = C2D(SUBSTR(ausgabetext, i, 1))
  IF maxhoehe < zeichenarr.aktnummer.hoehe THEN
    maxhoehe = zeichenarr.aktnummer.hoehe
END

/* Text an FleetMsg.text anfuegen */
IF maxhoehe > 0 THEN
  DO
  CALL CHAROUT 'STDOUT', 'Ausgabe auf dem Bildschirm oder in eine Datei (B/D) ? '
  PULL wohin
  wohin = SUBSTR(wohin, 1, 1, 'B')
  
  IF wohin = 'D' THEN
    DO
    CALL CHAROUT 'STDOUT', '   Dateiname ?   ---> '
    PULL ausgabedatei
    END
  ELSE
    SAY ''

  DO i = 1 TO maxhoehe
    zeile = ''
    
    DO j = 1 TO LENGTH(ausgabetext)
      aktzeichen = SUBSTR(ausgabetext, j, 1)
      aktnummer = C2D(aktzeichen)

      IF i <= zeichenarr.aktnummer.hoehe THEN 
        DO
        druckzeichen = zeichen				/* Wahl des Druckzeichens */
        IF druckzeichen == ' ' THEN
          druckzeichen =  aktzeichen

        hexwert = X2B(SUBSTR(zeichenarr.aktnummer.zeichen, 2 * i -1, 2))

	/* Achtung, der hexwert-String mu von hinten nach vorne gelesen werden, um das */
        /* richtige Ergebnis zu erzielen							  */

        DO k = 1 TO zeichenarr.aktnummer.breite
          IF SUBSTR(hexwert,9-k,1) \= 0 THEN		/* 9-k identisch 8-(k-1) */
            zeile = zeile || druckzeichen
          ELSE
            zeile = zeile || ' '
        END
	END
      ELSE
        DO k = 1 TO zeichenarr.aktnummer.breite
          zeile = zeile || ' '
        END
      IF j < LENGTH(ausgabetext) THEN
        DO l = 1 TO zwraum 
           zeile = zeile || ' '
        END
      END

    IF wohin = 'D' THEN
      erg = LINEOUT(ausgabedatei, zeile)
    ELSE
      SAY zeile
    END
  END
