(*************************************************************************

                           A.N.G.E.L. IGM UNIT
                    Copyright (c)2002 Atlantis Software
Version: 1.0
Updated: Oct 23 2002
**************************************************************************)
(* This igm.pas unit is a loader unit for all games or doors that use IGM's.
This file is always compiled when using ANGEL. You should add the IGM unit
for the door you are creating to the "uses" clause of the IMPLEMENTATION 
section below. You should also remove any unit that is not for the door you 
are creating. If you are creating a standard door, not an IGM, then this file 
should not be changed. 
When adding IGM support for a new game or door, all code in this unit should
be placed inside DEFINE blocks so that it is not compiled unless your door
is already defined. It should be defined at the beginning of the external unit
that contains your door or game API and also below. *)

unit igm;

{ Defines go here }
{...DEFINE ISAIGM}  { Define this if compiling ISA IGM  }
{...DEFINE LORDIGM} { Define this if compiling LORD IGM }

INTERFACE

uses
    crt;        { This should be only unit included for Regular doors }

{const and var's go below}
(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-Public Section+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)
const
 IgmUnitVersion = 'Version 1.0';


{ types }

procedure InitIGM;


(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-Private Section-*-+-*-+-*-+-*-+-*-+-*-+-*-*)
IMPLEMENTATION
(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)
uses
{alord,}      { Remove braces to compile Lord IGM }
{isaigm,}     { Remove braces to compile ISA IGM  }
dropfile,
angel;

{Functions and Procedures }

procedure InitIGM;
begin
{$IFDEF LORDIGM}
bbs.DropFile := 'info.' + Int2Str(bbs.node);
ReadInfoX;
{$ENDIF}

{$IFDEF ISAIGM}
{ ISA Init code goes here}
ReadUserOut;
{$ENDIF}

end;


END.

