/*
 * $Id$
 */
package com.mycompany.myproject.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

import org.xins.client.UnsuccessfulXINSCallException;
import org.xins.client.XINSCallRequest;
import org.xins.client.XINSCallResult;
import org.xins.client.XINSServiceCaller;

import org.xins.common.service.TargetDescriptor;
import org.xins.common.xml.Element;
import org.xins.common.xml.ElementBuilder;

/**
 * Implementation of the <code>MyFunction</code> tests.
 *
 * @version $Revision$ $Date$
 */
public class MyFunctionTests extends TestCase {

    /**
     * The XINServiceCaller of the API.
     */
    private XINSServiceCaller caller;

    /**
     * The URL of the tested API.
     */
    private String target;

    /**
     * Constructs a new <code>MyFunctionTests</code> test suite with
     * the specified name. The name will be passed to the superconstructor.
     *
     * @param name
     *     the name for this test suite.
     */
    public MyFunctionTests(String name) {
        super(name);
    }

    /**
     * Returns a test suite with all test cases defined by this class.
     *
     * @return
     *     the test suite, never <code>null</code>.
     */
    public static Test suite() {
        return new TestSuite(MyFunctionTests.class);
    }

    /**
     * Executes just this test.
     */
    public static void main(String args[]) {
        TestRunner.run(suite());
    }

    protected void setUp() throws Exception {
        target = System.getProperty("test.environment");
        if (target == null || target.trim().equals("")) {
            target = "http://localhost:8080/myproject/";
        }
        caller = new XINSServiceCaller(new TargetDescriptor(target));
    }

    protected void tearDown() throws Exception {
    }

    /**
     * Tests the MyFunction function by executing the example 1.
     *
     * Description: Missing parameter : lastName
     *
     * @throws Exception
     *    if an unexpected error occurs.
     */
    public void testMyFunctionExample1() throws Exception {
        XINSCallRequest request = new XINSCallRequest("MyFunction");
        request.setParameter("personLastName", "Bond 007");
        try {
            XINSCallResult result = caller.call(request);
            fail("An error code \"_InvalidRequest\" was expected but did not occur.");
        } catch(UnsuccessfulXINSCallException uxcex) {
            assertEquals("Incorrect error code received: " + uxcex.getErrorCode(), "_InvalidRequest", uxcex.getErrorCode());
        Element missing_param1 = (Element) uxcex.getDataElement().getChildElements().get(0);
        assertEquals("Incorrect element.", "missing-param" , missing_param1.getLocalName());
        assertEquals("The returned attribute \"param\" is incorrect.", "gender", missing_param1.getAttribute("param"));
        Element invalid_value_for_type2 = (Element) uxcex.getDataElement().getChildElements().get(1);
        assertEquals("Incorrect element.", "invalid-value-for-type" , invalid_value_for_type2.getLocalName());
        assertEquals("The returned attribute \"type\" is incorrect.", "LastName", invalid_value_for_type2.getAttribute("type"));
        assertEquals("The returned attribute \"param\" is incorrect.", "personLastName", invalid_value_for_type2.getAttribute("param"));
        }
    }

    /**
     * Tests the MyFunction function by executing the example 2.
     *
     * Description: The name does not contain any vowels.
     *
     * @throws Exception
     *    if an unexpected error occurs.
     */
    public void testMyFunctionExample2() throws Exception {
        XINSCallRequest request = new XINSCallRequest("MyFunction");
        request.setParameter("gender", "f");
        request.setParameter("personLastName", "cqfd");
        try {
            XINSCallResult result = caller.call(request);
            fail("An error code \"NoVowel\" was expected but did not occur.");
        } catch(UnsuccessfulXINSCallException uxcex) {
            assertEquals("Incorrect error code received: " + uxcex.getErrorCode(), "NoVowel", uxcex.getErrorCode());
        }
    }

    /**
     * Tests the MyFunction function by executing the example 3.
     *
     * Description: Message returned.
     *
     * @throws Exception
     *    if an unexpected error occurs.
     */
    public void testMyFunctionExample3() throws Exception {
        XINSCallRequest request = new XINSCallRequest("MyFunction");
        request.setParameter("gender", "f");
        request.setParameter("personLastName", "Lee");
        XINSCallResult result = caller.call(request);
        assertEquals("The returned parameter \"message\" is incorrect.", "Hello Miss Lee", result.getParameter("message"));
    }
}
