package jp.co.sra.smalltalk.menu;

import java.awt.CheckboxMenuItem;
import java.awt.MenuComponent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

/**
 * StRadioButtonMenuItemViewAwt class
 * 
 *  @author    nisinaka
 *  @created   2005/02/18 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StRadioButtonMenuItemViewAwt.java,v 8.9 2008/02/20 06:33:36 nisinaka Exp $
 */
public class StRadioButtonMenuItemViewAwt extends StCheckBoxMenuItemViewAwt implements StRadioButtonMenuItemView {

	/**
	 * Create a new instance of StRadioButtonMenuItemViewAwt and initialize it.
	 *
	 * @param aRadioButtonMenuItem jp.co.sra.smalltalk.menu.StRadioButtonMenuItem
	 * @category Instance creation
	 */
	public StRadioButtonMenuItemViewAwt(StRadioButtonMenuItem aRadioButtonMenuItem) {
		super(aRadioButtonMenuItem);
	}

	/**
	 * Answer my radio button menu item.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StRadioButtonMenuItem
	 * @see jp.co.sra.smalltalk.menu.StRadioButtonMenuItemView#getRadioButtonMenuItem()
	 * @category model accessing
	 */
	public StRadioButtonMenuItem getRadioButtonMenuItem() {
		return (StRadioButtonMenuItem) this.getMenuItem();
	}

	/**
	 * Create a menu item view.
	 * 
	 * @return java.awt.MenuComponent
	 * @category private
	 */
	protected MenuComponent createMenuItemView() {
		CheckboxMenuItem aCheckboxMenuItem = new CheckboxMenuItem();
		aCheckboxMenuItem.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				StRadioButtonMenuItemViewAwt aRadioButtonMenuItemView = StRadioButtonMenuItemViewAwt.this;
				if (e.getStateChange() == ItemEvent.SELECTED) {
					if (aRadioButtonMenuItemView.getCheckBoxMenuItem().isSelected() == false) {
						aRadioButtonMenuItemView.getCheckBoxMenuItem().beOn();
						aRadioButtonMenuItemView.performMenu($("selection"), e);
					}
				} else {
					aRadioButtonMenuItemView.updateSelection(); // to set the check mark.
					// notify the change?
				}
			}
		});
		return aCheckboxMenuItem;
	}

}