package jp.co.sra.smalltalk.menu;

import java.awt.Image;

import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StValued;

/**
 * StMenuItem class
 * 
 *  @author    nisinaka
 *  @created   2005/02/16 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StMenuItem.java,v 8.11 2008/02/20 06:33:36 nisinaka Exp $
 */
public class StMenuItem extends StAbstractMenuItem implements StValued {

	protected boolean isEnabled;
	protected Object label;
	protected Image labelImage;
	protected StSymbol nameKey;
	protected Object value;
	protected int shortcutKey;
	protected int shortcutModifiers;
	protected String helpText;

	/**
	 * Create a new instance of StMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @category Instance creation
	 */
	public StMenuItem(Object label) {
		this(label, null, null, null);
	}

	/**
	 * Create a new instance of StMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param shortcutKeyCharacter int
	 * @param shortcutModifiers int
	 * @category Instance creation
	 */
	public StMenuItem(Object label, int shortcutKeyCharacter, int shortcutModifiers) {
		this(label, null, null, null, shortcutKeyCharacter, shortcutModifiers);
	}

	/**
	 * Create a new instance of StMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param nameKey jp.co.sra.smalltalk.StSymbol
	 * @category Instance creation
	 */
	public StMenuItem(Object label, StSymbol nameKey) {
		this(label, nameKey, null, null);
	}

	/**
	 * Create a new instance of StMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param nameKey jp.co.sra.smalltalk.StSymbol
	 * @param labelImage java.awt.Image
	 * @category Instance creation
	 */
	public StMenuItem(Object label, StSymbol nameKey, Image labelImage) {
		this(label, nameKey, labelImage, null);
	}

	/**
	 * Create a new instance of StMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param nameKey jp.co.sra.smalltalk.StSymbol
	 * @param shortcutKeyCharacter int
	 * @param shortcutModifiers int
	 * @category Instance creation
	 */
	public StMenuItem(Object label, StSymbol nameKey, int shortcutKeyCharacter, int shortcutModifiers) {
		this(label, nameKey, null, null, shortcutKeyCharacter, shortcutModifiers);
	}

	/**
	 * Create a new instance of StMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param aMenuListener jp.co.sra.smalltalk.menu.MenuListener
	 * @category Instance creation
	 */
	public StMenuItem(Object label, MenuListener aMenuListener) {
		this(label, null, null, aMenuListener);
	}

	/**
	 * Create a new instance of StMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param labelImage java.awt.Image
	 * @param aMenuListener jp.co.sra.smalltalk.menu.MenuListener
	 * @category Instance creation
	 */
	public StMenuItem(Object label, Image labelImage, MenuListener aMenuListener) {
		this(label, null, labelImage, aMenuListener);
	}

	/**
	 * Create a new instance of StMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param nameKey jp.co.sra.smalltalk.StSymbol
	 * @param aMenuListener jp.co.sra.smalltalk.menu.MenuListener
	 * @category Instance creation
	 */
	public StMenuItem(Object label, StSymbol nameKey, MenuListener aMenuListener) {
		this(label, nameKey, null, aMenuListener, 0, 0);
	}

	/**
	 * Create a new instance of StMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param nameKey jp.co.sra.smalltalk.StSymbol
	 * @param aMenuListener jp.co.sra.smalltalk.menu.MenuListener
	 * @param shortcutKeyCharacter int
	 * @param shortcutModifiers int
	 * @category Instance creation
	 */
	public StMenuItem(Object label, StSymbol nameKey, MenuListener aMenuListener, int shortcutKeyCharacter, int shortcutModifiers) {
		this(label, nameKey, null, aMenuListener, shortcutKeyCharacter, shortcutModifiers);
	}

	/**
	 * Create a new instance of StMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param nameKey jp.co.sra.smalltalk.StSymbol
	 * @param labelImage java.awt.Image
	 * @param aMenuListener jp.co.sra.smalltalk.menu.MenuListener
	 * @category Instance creation
	 */
	public StMenuItem(Object label, StSymbol nameKey, Image labelImage, MenuListener aMenuListener) {
		this(label, nameKey, labelImage, aMenuListener, 0, 0);
	}

	/**
	 * Create a new instance of StMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param nameKey jp.co.sra.smalltalk.StSymbol
	 * @param labelImage java.awt.Image
	 * @param aMenuListener jp.co.sra.smalltalk.menu.MenuListener
	 * @param shortcutKeyCharacter int
	 * @param shortcutModifiers int
	 * @category Instance creation
	 */
	public StMenuItem(Object label, StSymbol nameKey, Image labelImage, MenuListener aMenuListener, int shortcutKeyCharacter, int shortcutModifiers) {
		this.initialize();
		this.setLabel_(label);
		this.setNameKey_(nameKey);
		this.setLabelImage_(labelImage);
		this.addMenuListener(aMenuListener);
		this.shortcutKeyCharacter_(shortcutKeyCharacter);
		this.shortcutModifiers_(shortcutModifiers);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @category initialize-release
	 */
	protected void initialize() {
		isEnabled = true;
		label = null;
		labelImage = null;
		nameKey = null;
		value = null;
		shortcutKey = 0;
		shortcutModifiers = 0;
		helpText = null;
	}

	/**
	 * Disable the receiver.
	 * 
	 * @category enabled/disabled
	 */
	public void disable() {
		this.beEnabled(false);
	}

	/**
	 * Enable the receiver.
	 * 
	 * @category enabled/disabled
	 */
	public void enable() {
		this.beEnabled(true);
	}

	/**
	 * Answer true if the receiver is enabled, otherwise false.
	 * 
	 * @return boolean
	 * @category enabled/disabled
	 */
	public boolean isEnabled() {
		return isEnabled;
	}

	/**
	 * Set whether the receiver is enabled or not.
	 * 
	 * @param aBoolean boolean
	 * @category enabled/disabled
	 */
	public void beEnabled(boolean aBoolean) {
		this.setEnabled_(aBoolean);
		this.changed_($("enabled"));
	}

	/**
	 * Answer my current label.
	 * 
	 * @return java.lang.Object
	 * @category labeling
	 */
	public Object label() {
		return label;
	}

	/**
	 * Set my new label.
	 * 
	 * @param anObject java.lang.Object
	 * @category labeling
	 */
	public void label_(Object anObject) {
		this.setLabel_(anObject);
		this.changed_($("label"));
	}

	/**
	 * Answer the string representation of my current label.
	 * 
	 * @return java.lang.String
	 * @category labeling
	 */
	public String labelString() {
		if (label == null) {
			return "";
		} else {
			return label.toString();
		}
	}

	/**
	 * Answer my current label image.
	 * 
	 * @return java.awt.Image
	 * @category accessing
	 */
	public Image labelImage() {
		return labelImage;
	}

	/**
	 * Set my new label image.
	 * 
	 * @param anImage java.awt.Image
	 * @category accessing
	 */
	public void labelImage_(Image anImage) {
		this.setLabelImage_(anImage);
		this.changed_($("labelImage"));
	}

	/**
	 * Answer my current name key.
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 * @category name keys
	 */
	public StSymbol nameKey() {
		if (nameKey == null) {
			nameKey = $(this.labelString());
		}
		return nameKey;
	}

	/**
	 * Set my new name key.
	 * 
	 * @param aSymbol jp.co.sra.smalltalk.StSymbol
	 * @category name keys
	 */
	public void nameKey_(StSymbol aSymbol) {
		this.setNameKey_(aSymbol);
		this.changed_($("nameKey"));
	}

	/**
	 * Answer my current value.
	 * 
	 * @return java.lang.Object
	 * @see jp.co.sra.smalltalk.StValued#value()
	 * @category accessing
	 */
	public Object value() {
		return value;
	}

	/**
	 * Set my new value.
	 * 
	 * @param anObject java.lang.Object
	 * @category accessing
	 */
	public void value_(Object anObject) {
		value = anObject;
	}

	/**
	 * Answer my current shortcut key character.
	 * 
	 * @return int
	 * @category shortcut key
	 */
	public int shortcutKeyCharacter() {
		return shortcutKey;
	}

	/**
	 * Set my my shortcut key character.
	 * Expect a virtual key defined in KeyEvent (i.e. KeyEvent.VK_A)
	 * 
	 * @param keyCode int
	 * @category shortcut key
	 */
	public void shortcutKeyCharacter_(int keyCode) {
		shortcutKey = keyCode;
	}

	/**
	 * Answer the shortcut key modifier integer for this menu item.
	 * 
	 * @return int
	 * @category shortcut key
	 */
	public int shortcutModifiers() {
		return shortcutModifiers;
	}

	/**
	 * Set the shortcut key modifier integer for his menu item.
	 * Expect a mask value, or combination of mask values, defined in InputEvent.
	 * 
	 * @param anInteger int
	 * @category shortcut key
	 */
	public void shortcutModifiers_(int anInteger) {
		shortcutModifiers = anInteger;
	}

	/**
	 * Answer my current help text.
	 * 
	 * @return java.lang.String
	 * @category accessing
	 */
	public String helpText() {
		return helpText;
	}

	/**
	 * Set my new help text.
	 * 
	 * @param aString java.lang.String
	 * @category accessing
	 */
	public void helpText_(String aString) {
		helpText = aString;
	}

	/**
	 * Create my default view.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenuItemView
	 * @category interface opening
	 */
	public StMenuItemView defaultView() {
		if (StApplicationModel.GetDefaultViewMode() == StApplicationModel.VIEW_AWT) {
			return new StMenuItemViewAwt(this);
		} else {
			return new StMenuItemViewSwing(this);
		}
	}

	/**
	 * Reset the label.
	 * 
	 * @category resetting
	 */
	public void resetAllLabels() {
		this.changed_($("label"));
	}

	/**
	 * Set my enabled flag silently.
	 * 
	 * @param aBoolean boolean
	 * @category private
	 */
	protected void setEnabled_(boolean aBoolean) {
		isEnabled = aBoolean;
	}

	/**
	 * Set my label silently.
	 * 
	 * @param anObject java.lang.Object
	 * @category private
	 */
	protected void setLabel_(Object anObject) {
		label = anObject;
	}

	/**
	 * Set my label image silently.
	 * 
	 * @param anImage java.awt.Image
	 * @category private
	 */
	protected void setLabelImage_(Image anImage) {
		labelImage = anImage;
	}

	/**
	 * Set my new name key silently.
	 * 
	 * @param aSymbol jp.co.sra.smalltalk.StSymbol
	 * @category private
	 */
	protected void setNameKey_(StSymbol aSymbol) {
		nameKey = aSymbol;
	}

}
