package jp.co.sra.smalltalk.menu;

import jp.co.sra.smalltalk.SmalltalkException;

/**
 * StMenuBar class
 * 
 *  @author    nisinaka
 *  @created   2005/02/17 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StMenuBar.java,v 8.9 2008/02/20 06:33:36 nisinaka Exp $
 */
public class StMenuBar extends StMenu {

	/**
	 * Create a new instance of StMenuBar.
	 * 
	 * @category Instance creation
	 */
	public StMenuBar() {
		this("");
	}

	/**
	 * Create a new instance of StMenuBar and initialize it.
	 *
	 * @param label java.lang.Object
	 * @category Instance creation
	 */
	private StMenuBar(Object label) {
		super(label);
	}

	/**
	 * Answer my menus.
	 * 
	 * @return jp.co.sra.smalltalk.StMenu[]
	 * @category menus
	 */
	public StMenu[] menus() {
		return (StMenu[]) items.toArray(new StMenu[items.size()]);
	}

	/**
	 * Add a new menu to the end of the menu bar.
	 * 
	 * @param aMenu jp.co.sra.smalltalk.menu.StMenu
	 * @category menus-adding
	 */
	public void add(StMenu aMenu) {
		super.add(aMenu);
	}

	/**
	 * The menu bar does not contain any menu items.
	 * 
	 * @param aMenuItem jp.co.sra.smalltalk.menu.StMenuItem
	 * @see jp.co.sra.smalltalk.menu.StMenu#add(jp.co.sra.smalltalk.menu.StMenuItem)
	 * @category menu items-adding
	 */
	public void add(StMenuItem aMenuItem) {
		throw new SmalltalkException("The menu bar does not contain any menu items.");
	}

}