package jp.co.sra.smalltalk;

import java.awt.Button;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * WindowSpecLayoutTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2003/05/08 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: WindowSpecLayoutTestExamples.java,v 8.10 2008/02/20 06:33:18 nisinaka Exp $
 */
public class WindowSpecLayoutTestExamples extends SmalltalkTestExamples {

	/**
	 * Example1:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		Panel aPanel = new Panel();
		aPanel.setLayout(new WindowSpecLayout());
		aPanel.add(new Button("button1"), WindowSpecLayout.Position(0f, 10, 0f, 10, 0.5f, -10, 0.5f, -10));
		aPanel.setSize(100, 100);

		Frame aFrame = new Frame();
		aFrame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		aFrame.add(aPanel);
		aFrame.pack();
		StApplicationModel._ShowAtMousePoint(aFrame);

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new WindowSpecLayoutTestExamples();
	}
}
