package jp.co.sra.smalltalk;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;

import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuBarView;
import jp.co.sra.smalltalk.menu.StPopupMenu;

/**
 * StView interface
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1999/06/03 (by MATSUDA Ryouichi)
 *  @updated   1999/11/11 (by MATSUDA Ryouichi)
 *  @updated   2002/01/23 (by nisinaka)
 *  @updated   2002/11/11 (by nisinaka)
 *  @updated   2006/10/04 (by nisinaka)
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StView.java,v 8.10 2008/02/20 06:33:18 nisinaka Exp $
 */
public interface StView extends DependentListener {

	/**
	 * Release the receiver.
	 * 
	 * @category initialize-release
	 */
	public void release();

	/**
	 * Answer my model.
	 * 
	 * @return jp.co.sra.smalltalk.StModel
	 * @category model accessing
	 */
	public StModel model();

	/**
	 * Set my model.
	 * 
	 * @param newModel jp.co.sra.smalltalk.StModel
	 * @category model accessing
	 */
	public void model_(StModel newModel);

	/**
	 * Answer my controller.
	 * 
	 * @return jp.co.sra.smalltalk.StController
	 * @category controller accessing
	 */
	public StController controller();

	/**
	 * Set my controller.
	 * 
	 * @param newController jp.co.sra.smalltalk.StController
	 * @category controller accessing
	 */
	public void controller_(StController newController);

	/**
	 * Answer the view as a java component.
	 *
	 * @return java.awt.Component
	 * @category converting
	 */
	public Component toComponent();

	/**
	 * Answer the top component of the view.
	 *
	 * @return java.awt.Window
	 * @category user interface
	 */
	public Window topComponent();

	/**
	 * Answer the bordered panel which contains the receiver.
	 *
	 * @return java.awt.Container
	 * @category interface opening
	 */
	public Container _onBorderedPanel();

	/**
	 * Set my popup menu view from the StPopupMenu.
	 * 
	 * @param aPopupMenu jp.co.sra.smalltalk.menu.StPopupMenu
	 * @category popup menu
	 */
	public void popupMenu_(StPopupMenu aPopupMenu);

	/**
	 * Show the popup menu at the specified point on the view.
	 *
	 * @param x int
	 * @param y int
	 * @category popup menu
	 */
	public void _showPopupMenu(int x, int y);

	/**
	 * Create my menu bar view.
	 * 
	 * @param aMenuBar jp.co.sra.smalltalk.menu.StMenuBar
	 * @return jp.co.sra.smalltalk.menu.StMenuBarView
	 * @category resources
	 */
	public StMenuBarView _createMenuBarView(StMenuBar aMenuBar);

	/**
	 * Set up the keyboard for the view on the window.
	 * 
	 * @param aWindow java.awt.Window
	 * @category keyboard
	 */
	public void _setupKeyboard(Window aWindow);

}
