package jp.co.sra.smalltalk;

/**
 * StUserMessage class
 * 
 *  @author    nisinaka
 *  @created   2005/03/09 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StUserMessage.java,v 8.10 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StUserMessage extends StObject {

	protected String key;
	protected String defaultString;
	protected StMessageCatalog catalog;
	protected Object[] arguments;

	/**
	 * Create a new instance of StUserMessage and initialize it.
	 *
	 * @param key java.lang.String
	 * @category Instance creation
	 */
	public StUserMessage(String key) {
		this(key, null);
	}

	/**
	 * Create a new instance of StUserMessage and initialize it.
	 *
	 * @param key java.lang.String
	 * @param defaultString java.lang.String
	 * @category Instance creation
	 */
	public StUserMessage(String key, String defaultString) {
		this(key, defaultString, null, null);
	}

	/**
	 * Create a new instance of StUserMessage and initialize it.
	 *
	 * @param key java.lang.String
	 * @param defaultString java.lang.String
	 * @param catalog jp.co.sra.smalltalk.StMessageCatalog
	 * @category Instance creation
	 */
	public StUserMessage(String key, String defaultString, StMessageCatalog catalog) {
		this(key, defaultString, catalog, null);
	}

	/**
	 * Create a new instance of StUserMessage and initialize it.
	 *
	 * @param key java.lang.String
	 * @param defaultString java.lang.String
	 * @param argument java.lang.Object
	 * @category Instance creation
	 */
	public StUserMessage(String key, String defaultString, Object argument) {
		this(key, defaultString, null, new Object[] { argument });
	}

	/**
	 * Create a new instance of StUserMessage and initialize it.
	 *
	 * @param key java.lang.String
	 * @param defaultString java.lang.String
	 * @param argument1 java.lang.Object
	 * @param argument2 java.lang.Object
	 * @category Instance creation
	 */
	public StUserMessage(String key, String defaultString, Object argument1, Object argument2) {
		this(key, defaultString, null, new Object[] { argument1, argument2 });
	}

	/**
	 * Create a new instance of StUserMessage and initialize it.
	 *
	 * @param key java.lang.String
	 * @param defaultString java.lang.String
	 * @param arguments java.lang.Object[]
	 * @category Instance creation
	 */
	public StUserMessage(String key, String defaultString, Object[] arguments) {
		this(key, defaultString, null, arguments);
	}

	/**
	 * Create a new instance of StUserMessage and initialize it.
	 *
	 * @param key java.lang.String
	 * @param defaultString java.lang.String
	 * @param catalog jp.co.sra.smalltalk.StMessageCatalog
	 * @param arguments java.lang.Object[]
	 * @category Instance creation
	 */
	public StUserMessage(String key, String defaultString, StMessageCatalog catalog, Object[] arguments) {
		this.key_(key);
		this.defaultString_(defaultString);
		this.catalog_(catalog);
		this.arguments = arguments;
	}

	/**
	 * Answer my current key.
	 * 
	 * @return java.lang.String
	 * @category accessing
	 */
	public String key() {
		return key;
	}

	/**
	 * Set my new key.
	 * 
	 * @param key java.lang.String
	 * @category accessing
	 */
	public void key_(String key) {
		this.key = key;
	}

	/**
	 * Answer my current defaultString.
	 * 
	 * @return java.lang.String
	 * @category accessing
	 */
	public String defaultString() {
		return defaultString;
	}

	/**
	 * Set my new defaultString.
	 * 
	 * @param defaultString java.lang.String
	 * @category accessing
	 */
	public void defaultString_(String defaultString) {
		this.defaultString = defaultString;
	}

	/**
	 * Answer my current catalog.
	 * 
	 * @return jp.co.sra.smalltalk.StMessageCatalog
	 * @category accessing
	 */
	public StMessageCatalog catalog() {
		return catalog;
	}

	/**
	 * Set my new catalog.
	 * 
	 * @param catalog jp.co.sra.smalltalk.StMessageCatalog
	 * @category accessing
	 */
	public void catalog_(StMessageCatalog catalog) {
		this.catalog = catalog;
	}

	/**
	 * Convert the receiver to a string.
	 * 
	 * @return java.lang.String
	 * @category converting
	 */
	public String asString() {
		String aString = StMessageCatalog.LookUp(this);
		if (aString == null) {
			aString = (defaultString == null) ? key : defaultString;
		}
		return aString;
	}

	/**
	 * Convert the receiver to a string with expanding the macros.
	 * 
	 * @return java.lang.String
	 * @see java.lang.Object#toString()
	 * @category converting
	 */
	public String toString() {
		return this.expandMacrosWithArguments(arguments);
	}

	/**
	 * Replace parameter markers with the appropriate representation of the argument.
	 * 
	 * @param argument java.lang.Object
	 * @return java.lang.String
	 * @category converting
	 */
	public String expandMacrosWith(Object argument) {
		return this.expandMacrosWithArguments(new Object[] { argument });
	}

	/**
	 * Replace parameter markers with the appropriate representation of the arguments.
	 * 
	 * @param argument1 java.lang.Object
	 * @param argument2 java.lang.Object
	 * @return java.lang.String
	 * @category converting
	 */
	public String expandMacrosWith(Object argument1, Object argument2) {
		return this.expandMacrosWithArguments(new Object[] { argument1, argument2 });
	}

	/**
	 * Replace parameter markers with the appropriate representation of the arguments.
	 * 
	 * @param arguments java.lang.Object[]
	 * @return java.lang.String
	 * @category converting
	 */
	public String expandMacrosWithArguments(Object[] arguments) {
		String string = this.asString();
		if (arguments != null) {
			for (int i = 0; i < arguments.length; i++) {
				string = string.replaceAll("<" + (i + 1) + "p>", QuoteReplacement(arguments[i].toString()));
			}
		}
		return string;
	}

	/**
	 * Quote the replacement string for String#relapceAll(String, String).
	 * This method will be introduced in java.util.regex.Matcher since JDK1.5.
	 * 
	 * @param s java.lang.String
	 * @return java.lang.String
	 * @category Converting
	 */
	public static String QuoteReplacement(String s) {
		if ((s.indexOf('\\') == -1) && (s.indexOf('$') == -1)) {
			return s;
		}

		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < s.length(); i++) {
			char c = s.charAt(i);
			if (c == '\\') {
				sb.append('\\');
				sb.append('\\');
			} else if (c == '$') {
				sb.append('\\');
				sb.append('$');
			} else {
				sb.append(c);
			}
		}
		return sb.toString();
	}

}
